/*
 * Decompiled with CFR 0.152.
 */
package com.borax12.materialdaterangepicker.date;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.widget.TextView;
import com.borax12.materialdaterangepicker.R;

public class TextViewWithCircularIndicator
extends TextView {
    private static final int SELECTED_CIRCLE_ALPHA = 255;
    Paint mCirclePaint = new Paint();
    private final int mRadius;
    private int mCircleColor;
    private final String mItemIsSelectedText;
    private boolean mDrawCircle;

    public TextViewWithCircularIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        Resources res = context.getResources();
        this.mCircleColor = res.getColor(R.color.range_accent_color);
        this.mRadius = res.getDimensionPixelOffset(R.dimen.range_month_select_circle_radius);
        this.mItemIsSelectedText = context.getResources().getString(R.string.range_item_is_selected);
        this.init();
    }

    private void init() {
        this.mCirclePaint.setFakeBoldText(true);
        this.mCirclePaint.setAntiAlias(true);
        this.mCirclePaint.setColor(this.mCircleColor);
        this.mCirclePaint.setTextAlign(Paint.Align.CENTER);
        this.mCirclePaint.setStyle(Paint.Style.FILL);
        this.mCirclePaint.setAlpha(255);
    }

    public void setAccentColor(int color2) {
        this.mCircleColor = color2;
        this.mCirclePaint.setColor(this.mCircleColor);
        this.setTextColor(this.createTextColor(color2));
    }

    private ColorStateList createTextColor(int accentColor) {
        int[][] states = new int[][]{{16842919}, {0x10100A1}, new int[0]};
        int[] colors = new int[]{accentColor, -1, -16777216};
        return new ColorStateList((int[][])states, colors);
    }

    public void drawIndicator(boolean drawCircle) {
        this.mDrawCircle = drawCircle;
    }

    public void onDraw(@NonNull Canvas canvas) {
        if (this.mDrawCircle) {
            int width = this.getWidth();
            int height = this.getHeight();
            int radius = Math.min(width, height) / 2;
            canvas.drawCircle((float)(width / 2), (float)(height / 2), (float)radius, this.mCirclePaint);
        }
        this.setSelected(this.mDrawCircle);
        super.onDraw(canvas);
    }

    public CharSequence getContentDescription() {
        CharSequence itemText = this.getText();
        if (this.mDrawCircle) {
            return String.format(this.mItemIsSelectedText, itemText);
        }
        return itemText;
    }
}

