/*
 * Decompiled with CFR 0.152.
 */
package com.borax12.materialdaterangepicker.date;

import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.DialogFragment;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.format.DateUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TabHost;
import android.widget.TextView;
import com.borax12.materialdaterangepicker.HapticFeedbackController;
import com.borax12.materialdaterangepicker.R;
import com.borax12.materialdaterangepicker.TypefaceHelper;
import com.borax12.materialdaterangepicker.Utils;
import com.borax12.materialdaterangepicker.date.AccessibleDateAnimator;
import com.borax12.materialdaterangepicker.date.DatePickerController;
import com.borax12.materialdaterangepicker.date.DayPickerView;
import com.borax12.materialdaterangepicker.date.MonthAdapter;
import com.borax12.materialdaterangepicker.date.SimpleDayPickerView;
import com.borax12.materialdaterangepicker.date.YearPickerView;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;

public class DatePickerDialog
extends DialogFragment
implements View.OnClickListener,
DatePickerController {
    private static final String TAG = "DatePickerDialog";
    private static final int UNINITIALIZED = -1;
    private static final int MONTH_AND_DAY_VIEW = 0;
    private static final int YEAR_VIEW = 1;
    private static final String KEY_SELECTED_YEAR = "year";
    private static final String KEY_SELECTED_YEAR_END = "year_end";
    private static final String KEY_SELECTED_MONTH = "month";
    private static final String KEY_SELECTED_MONTH_END = "month_end";
    private static final String KEY_SELECTED_DAY = "day";
    private static final String KEY_SELECTED_DAY_END = "day_end";
    private static final String KEY_LIST_POSITION = "list_position";
    private static final String KEY_LIST_POSITION_END = "list_position_end";
    private static final String KEY_WEEK_START = "week_start";
    private static final String KEY_WEEK_START_END = "week_start_end";
    private static final String KEY_YEAR_START = "year_start";
    private static final String KEY_YEAR_START_END = "year_start_end";
    private static final String KEY_MAX_YEAR = "max_year";
    private static final String KEY_MAX_YEAR_END = "max_year_end";
    private static final String KEY_CURRENT_VIEW = "current_view";
    private static final String KEY_CURRENT_VIEW_END = "current_view_end";
    private static final String KEY_LIST_POSITION_OFFSET = "list_position_offset";
    private static final String KEY_LIST_POSITION_OFFSET_END = "list_position_offset_end";
    private static final String KEY_MIN_DATE = "min_date";
    private static final String KEY_MAX_DATE = "max_date";
    private static final String KEY_HIGHLIGHTED_DAYS = "highlighted_days";
    private static final String KEY_SELECTABLE_DAYS = "selectable_days";
    private static final String KEY_MIN_DATE_END = "min_date_end";
    private static final String KEY_MAX_DATE_END = "max_date_end";
    private static final String KEY_HIGHLIGHTED_DAYS_END = "highlighted_days_end";
    private static final String KEY_SELECTABLE_DAYS_END = "selectable_days_end";
    private static final String KEY_THEME_DARK = "theme_dark";
    private static final String KEY_ACCENT = "accent";
    private static final String KEY_VIBRATE = "vibrate";
    private static final String KEY_DISMISS = "dismiss";
    private static final int DEFAULT_START_YEAR = 1900;
    private static final int DEFAULT_END_YEAR = 2100;
    private static final int ANIMATION_DURATION = 300;
    private static final int ANIMATION_DELAY = 500;
    private static SimpleDateFormat YEAR_FORMAT = new SimpleDateFormat("yyyy", Locale.getDefault());
    private static SimpleDateFormat DAY_FORMAT = new SimpleDateFormat("dd", Locale.getDefault());
    private Calendar mCalendar = Calendar.getInstance();
    private Calendar mCalendarEnd = Calendar.getInstance();
    private OnDateSetListener mCallBack;
    private HashSet<OnDateChangedListener> mListeners = new HashSet();
    private DialogInterface.OnCancelListener mOnCancelListener;
    private DialogInterface.OnDismissListener mOnDismissListener;
    private AccessibleDateAnimator mAnimator;
    private TextView mDayOfWeekView;
    private LinearLayout mMonthAndDayView;
    private TextView mSelectedMonthTextView;
    private TextView mSelectedDayTextView;
    private TextView mYearView;
    private DayPickerView mDayPickerView;
    private YearPickerView mYearPickerView;
    private int mCurrentView = -1;
    private int mCurrentViewEnd = -1;
    private int mWeekStart = this.mCalendar.getFirstDayOfWeek();
    private int mWeekStartEnd = this.mCalendarEnd.getFirstDayOfWeek();
    private int mMinYear = 1900;
    private int mMaxYear = 2100;
    private Calendar mMinDate;
    private Calendar mMaxDate;
    private Calendar[] highlightedDays;
    private Calendar[] selectableDays;
    private Calendar mMinDateEnd;
    private Calendar mMaxDateEnd;
    private Calendar[] highlightedDaysEnd;
    private Calendar[] selectableDaysEnd;
    private boolean mAutoHighlight = false;
    private boolean mThemeDark;
    private int mAccentColor = -1;
    private boolean mVibrate;
    private boolean mDismissOnPause;
    private HapticFeedbackController mHapticFeedbackController;
    private boolean mDelayAnimation = true;
    private String mDayPickerDescription;
    private String mSelectDay;
    private String mYearPickerDescription;
    private String mSelectYear;
    private TabHost tabHost;
    private LinearLayout mMonthAndDayViewEnd;
    private TextView mSelectedMonthTextViewEnd;
    private TextView mSelectedDayTextViewEnd;
    private TextView mYearViewEnd;
    private SimpleDayPickerView mDayPickerViewEnd;
    private YearPickerView mYearPickerViewEnd;
    private AccessibleDateAnimator mAnimatorEnd;
    private int tabTag = 1;
    private String startTitle;
    private String endTitle;

    public static DatePickerDialog newInstance(OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth) {
        DatePickerDialog ret = new DatePickerDialog();
        ret.initialize(callBack, year, monthOfYear, dayOfMonth);
        return ret;
    }

    public static DatePickerDialog newInstance(OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth, int yearEnd, int montOfYearEnd, int dayOfMonthEnd) {
        DatePickerDialog ret = new DatePickerDialog();
        ret.initialize(callBack, year, monthOfYear, dayOfMonth, yearEnd, montOfYearEnd, dayOfMonthEnd);
        return ret;
    }

    public void initialize(OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth) {
        this.initialize(callBack, year, monthOfYear, dayOfMonth, year, monthOfYear, dayOfMonth);
    }

    public void initialize(OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth, int yearEnd, int montOfYearEnd, int dayOfMonthEnd) {
        this.mCallBack = callBack;
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, monthOfYear);
        this.mCalendar.set(5, dayOfMonth);
        this.mCalendarEnd.set(1, yearEnd);
        this.mCalendarEnd.set(2, montOfYearEnd);
        this.mCalendarEnd.set(5, dayOfMonthEnd);
        this.mThemeDark = false;
        this.mAccentColor = -1;
        this.mVibrate = true;
        this.mDismissOnPause = false;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Activity activity = this.getActivity();
        activity.getWindow().setSoftInputMode(3);
        if (savedInstanceState != null) {
            this.mCalendar.set(1, savedInstanceState.getInt(KEY_SELECTED_YEAR));
            this.mCalendar.set(2, savedInstanceState.getInt(KEY_SELECTED_MONTH));
            this.mCalendar.set(5, savedInstanceState.getInt(KEY_SELECTED_DAY));
            this.mCalendarEnd.set(1, savedInstanceState.getInt(KEY_SELECTED_YEAR_END));
            this.mCalendarEnd.set(2, savedInstanceState.getInt(KEY_SELECTED_MONTH_END));
            this.mCalendarEnd.set(5, savedInstanceState.getInt(KEY_SELECTED_DAY_END));
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(KEY_SELECTED_YEAR, this.mCalendar.get(1));
        outState.putInt(KEY_SELECTED_MONTH, this.mCalendar.get(2));
        outState.putInt(KEY_SELECTED_DAY, this.mCalendar.get(5));
        outState.putInt(KEY_WEEK_START, this.mWeekStart);
        outState.putInt(KEY_YEAR_START, this.mMinYear);
        outState.putInt(KEY_MAX_YEAR, this.mMaxYear);
        outState.putInt(KEY_CURRENT_VIEW, this.mCurrentView);
        outState.putInt(KEY_SELECTED_YEAR_END, this.mCalendarEnd.get(1));
        outState.putInt(KEY_SELECTED_MONTH_END, this.mCalendarEnd.get(2));
        outState.putInt(KEY_SELECTED_DAY_END, this.mCalendarEnd.get(5));
        outState.putInt(KEY_WEEK_START_END, this.mWeekStartEnd);
        outState.putInt(KEY_YEAR_START_END, this.mMinYear);
        outState.putInt(KEY_MAX_YEAR_END, this.mMaxYear);
        outState.putInt(KEY_CURRENT_VIEW_END, this.mCurrentViewEnd);
        int listPosition = -1;
        int listPositionEnd = -1;
        if (this.mCurrentView == 0 || this.mCurrentViewEnd == 0) {
            listPosition = this.mDayPickerView.getMostVisiblePosition();
            listPositionEnd = this.mDayPickerViewEnd.getMostVisiblePosition();
        } else if (this.mCurrentView == 1 || this.mCurrentViewEnd == 1) {
            listPosition = this.mYearPickerView.getFirstVisiblePosition();
            listPositionEnd = this.mYearPickerViewEnd.getFirstVisiblePosition();
            outState.putInt(KEY_LIST_POSITION_OFFSET, this.mYearPickerView.getFirstPositionOffset());
            outState.putInt(KEY_LIST_POSITION_OFFSET_END, this.mYearPickerViewEnd.getFirstPositionOffset());
        }
        outState.putInt(KEY_LIST_POSITION, listPosition);
        outState.putInt(KEY_LIST_POSITION_END, listPositionEnd);
        outState.putSerializable(KEY_MIN_DATE, (Serializable)this.mMinDate);
        outState.putSerializable(KEY_MAX_DATE, (Serializable)this.mMaxDate);
        outState.putSerializable(KEY_MIN_DATE_END, (Serializable)this.mMinDateEnd);
        outState.putSerializable(KEY_MAX_DATE_END, (Serializable)this.mMaxDateEnd);
        outState.putSerializable(KEY_HIGHLIGHTED_DAYS, (Serializable)this.highlightedDays);
        outState.putSerializable(KEY_SELECTABLE_DAYS, (Serializable)this.selectableDays);
        outState.putSerializable(KEY_HIGHLIGHTED_DAYS_END, (Serializable)this.highlightedDaysEnd);
        outState.putSerializable(KEY_SELECTABLE_DAYS_END, (Serializable)this.selectableDaysEnd);
        outState.putBoolean(KEY_THEME_DARK, this.mThemeDark);
        outState.putInt(KEY_ACCENT, this.mAccentColor);
        outState.putBoolean(KEY_VIBRATE, this.mVibrate);
        outState.putBoolean(KEY_DISMISS, this.mDismissOnPause);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        int accentColor;
        this.getDialog().getWindow().requestFeature(1);
        View view = inflater.inflate(R.layout.range_date_picker_dialog, null);
        this.tabHost = (TabHost)view.findViewById(R.id.range_tabHost);
        this.tabHost.findViewById(R.id.range_tabHost);
        this.tabHost.setup();
        Activity activity = this.getActivity();
        TabHost.TabSpec startDatePage = this.tabHost.newTabSpec("start");
        startDatePage.setContent(R.id.start_date_group);
        startDatePage.setIndicator((CharSequence)(this.startTitle != null && !this.startTitle.isEmpty() ? this.startTitle : activity.getResources().getString(R.string.range_from)));
        TabHost.TabSpec endDatePage = this.tabHost.newTabSpec("end");
        endDatePage.setContent(R.id.range_end_date_group);
        endDatePage.setIndicator((CharSequence)(this.endTitle != null && !this.endTitle.isEmpty() ? this.endTitle : activity.getResources().getString(R.string.range_to)));
        this.tabHost.addTab(startDatePage);
        this.tabHost.addTab(endDatePage);
        this.mDayOfWeekView = (TextView)view.findViewById(R.id.range_date_picker_header);
        this.mMonthAndDayView = (LinearLayout)view.findViewById(R.id.range_date_picker_month_and_day);
        this.mMonthAndDayViewEnd = (LinearLayout)view.findViewById(R.id.range_date_picker_month_and_day_end);
        this.mMonthAndDayView.setOnClickListener((View.OnClickListener)this);
        this.mMonthAndDayViewEnd.setOnClickListener((View.OnClickListener)this);
        this.mSelectedMonthTextView = (TextView)view.findViewById(R.id.range_date_picker_month);
        this.mSelectedMonthTextViewEnd = (TextView)view.findViewById(R.id.range_date_picker_month_end);
        this.mSelectedDayTextView = (TextView)view.findViewById(R.id.range_date_picker_day);
        this.mSelectedDayTextViewEnd = (TextView)view.findViewById(R.id.range_date_picker_day_end);
        this.mYearView = (TextView)view.findViewById(R.id.range_date_picker_year);
        this.mYearViewEnd = (TextView)view.findViewById(R.id.range_date_picker_year_end);
        this.mYearView.setOnClickListener((View.OnClickListener)this);
        this.mYearViewEnd.setOnClickListener((View.OnClickListener)this);
        int listPosition = -1;
        int listPositionOffset = 0;
        int listPositionEnd = -1;
        int listPositionOffsetEnd = 0;
        int currentView = 0;
        int currentViewEnd = 0;
        if (savedInstanceState != null) {
            this.mWeekStart = savedInstanceState.getInt(KEY_WEEK_START);
            this.mWeekStartEnd = savedInstanceState.getInt(KEY_WEEK_START_END);
            this.mMinYear = savedInstanceState.getInt(KEY_YEAR_START);
            this.mMaxYear = savedInstanceState.getInt(KEY_MAX_YEAR);
            currentView = savedInstanceState.getInt(KEY_CURRENT_VIEW);
            currentViewEnd = savedInstanceState.getInt(KEY_CURRENT_VIEW_END);
            listPosition = savedInstanceState.getInt(KEY_LIST_POSITION);
            listPositionOffset = savedInstanceState.getInt(KEY_LIST_POSITION_OFFSET);
            listPositionEnd = savedInstanceState.getInt(KEY_LIST_POSITION_END);
            listPositionOffsetEnd = savedInstanceState.getInt(KEY_LIST_POSITION_OFFSET_END);
            this.mMinDate = (Calendar)savedInstanceState.getSerializable(KEY_MIN_DATE);
            this.mMaxDate = (Calendar)savedInstanceState.getSerializable(KEY_MAX_DATE);
            this.mMinDateEnd = (Calendar)savedInstanceState.getSerializable(KEY_MIN_DATE_END);
            this.mMaxDateEnd = (Calendar)savedInstanceState.getSerializable(KEY_MAX_DATE_END);
            this.highlightedDays = (Calendar[])savedInstanceState.getSerializable(KEY_HIGHLIGHTED_DAYS);
            this.selectableDays = (Calendar[])savedInstanceState.getSerializable(KEY_SELECTABLE_DAYS);
            this.highlightedDaysEnd = (Calendar[])savedInstanceState.getSerializable(KEY_HIGHLIGHTED_DAYS_END);
            this.selectableDaysEnd = (Calendar[])savedInstanceState.getSerializable(KEY_SELECTABLE_DAYS_END);
            this.mThemeDark = savedInstanceState.getBoolean(KEY_THEME_DARK);
            this.mAccentColor = savedInstanceState.getInt(KEY_ACCENT);
            this.mVibrate = savedInstanceState.getBoolean(KEY_VIBRATE);
            this.mDismissOnPause = savedInstanceState.getBoolean(KEY_DISMISS);
        }
        this.mDayPickerView = new SimpleDayPickerView((Context)activity, this);
        this.mYearPickerView = new YearPickerView((Context)activity, this);
        this.mDayPickerViewEnd = new SimpleDayPickerView((Context)activity, this);
        this.mYearPickerViewEnd = new YearPickerView((Context)activity, this);
        Resources res = this.getResources();
        this.mDayPickerDescription = res.getString(R.string.range_day_picker_description);
        this.mSelectDay = res.getString(R.string.range_select_day);
        this.mYearPickerDescription = res.getString(R.string.range_year_picker_description);
        this.mSelectYear = res.getString(R.string.range_select_year);
        int bgColorResource = this.mThemeDark ? R.color.range_date_picker_view_animator_dark_theme : R.color.range_date_picker_view_animator;
        view.setBackgroundColor(ContextCompat.getColor((Context)activity, (int)bgColorResource));
        this.mAnimator = (AccessibleDateAnimator)view.findViewById(R.id.range_animator);
        this.mAnimatorEnd = (AccessibleDateAnimator)view.findViewById(R.id.range_animator_end);
        this.mAnimator.addView((View)this.mDayPickerView);
        this.mAnimator.addView((View)this.mYearPickerView);
        this.mAnimator.setDateMillis(this.mCalendar.getTimeInMillis());
        AlphaAnimation animation = new AlphaAnimation(0.0f, 1.0f);
        animation.setDuration(300L);
        this.mAnimator.setInAnimation((Animation)animation);
        AlphaAnimation animation2 = new AlphaAnimation(1.0f, 0.0f);
        animation2.setDuration(300L);
        this.mAnimator.setOutAnimation((Animation)animation2);
        this.mAnimatorEnd.addView((View)this.mDayPickerViewEnd);
        this.mAnimatorEnd.addView((View)this.mYearPickerViewEnd);
        this.mAnimatorEnd.setDateMillis(this.mCalendarEnd.getTimeInMillis());
        AlphaAnimation animationEnd = new AlphaAnimation(0.0f, 1.0f);
        animationEnd.setDuration(300L);
        this.mAnimatorEnd.setInAnimation((Animation)animation);
        AlphaAnimation animation2End = new AlphaAnimation(1.0f, 0.0f);
        animation2End.setDuration(300L);
        this.mAnimatorEnd.setOutAnimation((Animation)animation2);
        Button okButton = (Button)view.findViewById(R.id.range_ok);
        okButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DatePickerDialog.this.tryVibrate();
                if (DatePickerDialog.this.mCallBack != null) {
                    DatePickerDialog.this.mCallBack.onDateSet(DatePickerDialog.this, DatePickerDialog.this.mCalendar.get(1), DatePickerDialog.this.mCalendar.get(2), DatePickerDialog.this.mCalendar.get(5), DatePickerDialog.this.mCalendarEnd.get(1), DatePickerDialog.this.mCalendarEnd.get(2), DatePickerDialog.this.mCalendarEnd.get(5));
                }
                DatePickerDialog.this.dismiss();
            }
        });
        okButton.setTypeface(TypefaceHelper.get((Context)activity, "Roboto-Medium"));
        Button cancelButton = (Button)view.findViewById(R.id.range_cancel);
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DatePickerDialog.this.tryVibrate();
                if (DatePickerDialog.this.getDialog() != null) {
                    DatePickerDialog.this.getDialog().cancel();
                }
            }
        });
        cancelButton.setTypeface(TypefaceHelper.get((Context)activity, "Roboto-Medium"));
        cancelButton.setVisibility(this.isCancelable() ? 0 : 8);
        if (this.mAccentColor == -1 && (accentColor = Utils.getAccentColorFromThemeIfAvailable((Context)this.getActivity())) != -1) {
            this.mAccentColor = accentColor;
        }
        if (this.mAccentColor != -1) {
            if (this.mDayOfWeekView != null) {
                this.mDayOfWeekView.setBackgroundColor(Utils.darkenColor(this.mAccentColor));
            }
            view.findViewById(R.id.range_day_picker_selected_date_layout).setBackgroundColor(this.mAccentColor);
            view.findViewById(R.id.range_day_picker_selected_date_layout_end).setBackgroundColor(this.mAccentColor);
            okButton.setTextColor(this.mAccentColor);
            cancelButton.setTextColor(this.mAccentColor);
            this.mYearPickerView.setAccentColor(this.mAccentColor);
            this.mDayPickerView.setAccentColor(this.mAccentColor);
            this.mYearPickerViewEnd.setAccentColor(this.mAccentColor);
            this.mDayPickerViewEnd.setAccentColor(this.mAccentColor);
        }
        this.updateDisplay(false);
        this.setCurrentView(currentView);
        if (listPosition != -1) {
            if (currentView == 0) {
                this.mDayPickerView.postSetSelection(listPosition);
            } else if (currentView == 1) {
                this.mYearPickerView.postSetSelectionFromTop(listPosition, listPositionOffset);
            }
        }
        if (listPositionEnd != -1) {
            if (currentViewEnd == 0) {
                this.mDayPickerViewEnd.postSetSelection(listPositionEnd);
            } else if (currentViewEnd == 1) {
                this.mYearPickerViewEnd.postSetSelectionFromTop(listPositionEnd, listPositionOffsetEnd);
            }
        }
        this.mHapticFeedbackController = new HapticFeedbackController((Context)activity);
        this.tabHost.setOnTabChangedListener(new TabHost.OnTabChangeListener(){

            public void onTabChanged(String tabId) {
                if (tabId.equals("start")) {
                    MonthAdapter.CalendarDay calendarDay = new MonthAdapter.CalendarDay(DatePickerDialog.this.mCalendar.getTimeInMillis());
                    DatePickerDialog.this.mDayPickerView.goTo(calendarDay, true, true, false);
                } else {
                    MonthAdapter.CalendarDay calendarDay = new MonthAdapter.CalendarDay(DatePickerDialog.this.mCalendarEnd.getTimeInMillis());
                    DatePickerDialog.this.mDayPickerViewEnd.goTo(calendarDay, true, true, false);
                }
            }
        });
        return view;
    }

    public void onResume() {
        super.onResume();
        this.mHapticFeedbackController.start();
    }

    public void onPause() {
        super.onPause();
        this.mHapticFeedbackController.stop();
        if (this.mDismissOnPause) {
            this.dismiss();
        }
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        if (this.mOnCancelListener != null) {
            this.mOnCancelListener.onCancel(dialog);
        }
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss(dialog);
        }
    }

    public boolean isAutoHighlight() {
        return this.mAutoHighlight;
    }

    public void setAutoHighlight(boolean autoHighlight) {
        this.mAutoHighlight = autoHighlight;
        if (autoHighlight) {
            this.calculateHighlightedDays();
        } else {
            this.highlightedDays = null;
            this.highlightedDaysEnd = null;
        }
    }

    private void setCurrentView(int viewIndex) {
        long millis = this.mCalendar.getTimeInMillis();
        long millisEnd = this.mCalendarEnd.getTimeInMillis();
        switch (viewIndex) {
            case 0: {
                ObjectAnimator pulseAnimator = Utils.getPulseAnimator((View)this.mMonthAndDayView, 0.9f, 1.05f);
                ObjectAnimator pulseAnimatorTwo = Utils.getPulseAnimator((View)this.mMonthAndDayViewEnd, 0.9f, 1.05f);
                if (this.mDelayAnimation) {
                    pulseAnimator.setStartDelay(500L);
                    pulseAnimatorTwo.setStartDelay(500L);
                    this.mDelayAnimation = false;
                }
                this.mDayPickerView.onDateChanged();
                if (this.mCurrentView != viewIndex) {
                    this.mMonthAndDayView.setSelected(true);
                    this.mMonthAndDayViewEnd.setSelected(true);
                    this.mYearView.setSelected(false);
                    this.mYearViewEnd.setSelected(false);
                    this.mAnimator.setDisplayedChild(0);
                    this.mAnimatorEnd.setDisplayedChild(0);
                    this.mCurrentView = viewIndex;
                }
                pulseAnimator.start();
                pulseAnimatorTwo.start();
                int flags = 16;
                String dayString = DateUtils.formatDateTime((Context)this.getActivity(), (long)millis, (int)flags);
                String dayStringEnd = DateUtils.formatDateTime((Context)this.getActivity(), (long)millisEnd, (int)flags);
                this.mAnimator.setContentDescription(this.mDayPickerDescription + ": " + dayString);
                this.mAnimatorEnd.setContentDescription(this.mDayPickerDescription + ": " + dayStringEnd);
                Utils.tryAccessibilityAnnounce((View)this.mAnimator, this.mSelectDay);
                Utils.tryAccessibilityAnnounce((View)this.mAnimatorEnd, this.mSelectDay);
                break;
            }
            case 1: {
                ObjectAnimator pulseAnimator = Utils.getPulseAnimator((View)this.mYearView, 0.85f, 1.1f);
                ObjectAnimator pulseAnimatorTwo = Utils.getPulseAnimator((View)this.mYearViewEnd, 0.85f, 1.1f);
                if (this.mDelayAnimation) {
                    pulseAnimator.setStartDelay(500L);
                    pulseAnimatorTwo.setStartDelay(500L);
                    this.mDelayAnimation = false;
                }
                this.mYearPickerView.onDateChanged();
                this.mYearPickerViewEnd.onDateChanged();
                if (this.mCurrentView != viewIndex) {
                    this.mMonthAndDayView.setSelected(false);
                    this.mYearView.setSelected(true);
                    this.mAnimator.setDisplayedChild(1);
                    this.mCurrentView = viewIndex;
                    this.mMonthAndDayViewEnd.setSelected(false);
                    this.mYearViewEnd.setSelected(true);
                    this.mAnimatorEnd.setDisplayedChild(1);
                    this.mCurrentViewEnd = viewIndex;
                }
                pulseAnimator.start();
                pulseAnimatorTwo.start();
                String yearString = YEAR_FORMAT.format(millis);
                String yearStringEnd = YEAR_FORMAT.format(millisEnd);
                this.mAnimator.setContentDescription(this.mYearPickerDescription + ": " + yearString);
                this.mAnimatorEnd.setContentDescription(this.mYearPickerDescription + ": " + yearStringEnd);
                Utils.tryAccessibilityAnnounce((View)this.mAnimator, this.mSelectYear);
                Utils.tryAccessibilityAnnounce((View)this.mAnimatorEnd, this.mSelectYear);
            }
        }
    }

    private void updateDisplay(boolean announce) {
        if (this.mDayOfWeekView != null) {
            this.mDayOfWeekView.setText((CharSequence)this.mCalendar.getDisplayName(7, 2, Locale.getDefault()).toUpperCase(Locale.getDefault()));
        }
        this.mSelectedMonthTextView.setText((CharSequence)this.mCalendar.getDisplayName(2, 1, Locale.getDefault()).toUpperCase(Locale.getDefault()));
        this.mSelectedMonthTextViewEnd.setText((CharSequence)this.mCalendarEnd.getDisplayName(2, 1, Locale.getDefault()).toUpperCase(Locale.getDefault()));
        this.mSelectedDayTextView.setText((CharSequence)DAY_FORMAT.format(this.mCalendar.getTime()));
        this.mSelectedDayTextViewEnd.setText((CharSequence)DAY_FORMAT.format(this.mCalendarEnd.getTime()));
        this.mYearView.setText((CharSequence)YEAR_FORMAT.format(this.mCalendar.getTime()));
        this.mYearViewEnd.setText((CharSequence)YEAR_FORMAT.format(this.mCalendarEnd.getTime()));
        long millis = this.mCalendar.getTimeInMillis();
        long millisEnd = this.mCalendarEnd.getTimeInMillis();
        this.mAnimator.setDateMillis(millis);
        this.mAnimatorEnd.setDateMillis(millisEnd);
        int flags = 24;
        String monthAndDayText = DateUtils.formatDateTime((Context)this.getActivity(), (long)millis, (int)flags);
        String monthAndDayTextEnd = DateUtils.formatDateTime((Context)this.getActivity(), (long)millisEnd, (int)flags);
        this.mMonthAndDayView.setContentDescription((CharSequence)monthAndDayText);
        this.mMonthAndDayViewEnd.setContentDescription((CharSequence)monthAndDayTextEnd);
        if (announce) {
            flags = 20;
            String fullDateText = DateUtils.formatDateTime((Context)this.getActivity(), (long)millis, (int)flags);
            String fullDateTextEnd = DateUtils.formatDateTime((Context)this.getActivity(), (long)millisEnd, (int)flags);
            Utils.tryAccessibilityAnnounce((View)this.mAnimator, fullDateText);
            Utils.tryAccessibilityAnnounce((View)this.mAnimatorEnd, fullDateTextEnd);
        }
    }

    public void vibrate(boolean vibrate) {
        this.mVibrate = vibrate;
    }

    public void dismissOnPause(boolean dismissOnPause) {
        this.mDismissOnPause = dismissOnPause;
    }

    public void setThemeDark(boolean themeDark) {
        this.mThemeDark = themeDark;
    }

    @Override
    public boolean isThemeDark() {
        return this.mThemeDark;
    }

    public void setAccentColor(int accentColor) {
        this.mAccentColor = accentColor;
    }

    public int getAccentColor() {
        return this.mAccentColor;
    }

    public void setFirstDayOfWeek(int startOfWeek, int startWeekEnd) {
        if (startOfWeek < 1 || startOfWeek > 7) {
            throw new IllegalArgumentException("Value must be between Calendar.SUNDAY and Calendar.SATURDAY");
        }
        this.mWeekStart = startOfWeek;
        this.mWeekStartEnd = startWeekEnd;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
        if (this.mDayPickerViewEnd != null) {
            this.mDayPickerViewEnd.onChange();
        }
    }

    public void setYearRange(int startYear, int endYear) {
        if (endYear < startYear) {
            throw new IllegalArgumentException("Year end must be larger than or equal to year start");
        }
        this.mMinYear = startYear;
        this.mMaxYear = endYear;
        if (this.mDayPickerView != null && this.mDayPickerViewEnd != null) {
            this.mDayPickerView.onChange();
            this.mDayPickerViewEnd.onChange();
        }
    }

    public void setMinDate(Calendar calendar) {
        this.mMinDate = calendar;
        if (this.mDayPickerView != null && this.mDayPickerViewEnd != null) {
            this.mDayPickerView.onChange();
            this.mDayPickerViewEnd.onChange();
        }
    }

    @Override
    public Calendar getMinDate() {
        return this.mMinDate;
    }

    public void setMaxDate(Calendar calendar) {
        this.mMaxDate = calendar;
        if (this.mDayPickerView != null && this.mDayPickerViewEnd != null) {
            this.mDayPickerView.onChange();
            this.mDayPickerViewEnd.onChange();
        }
    }

    @Override
    public Calendar getMaxDate() {
        return this.mMaxDate;
    }

    public void setHighlightedDays(Calendar[] highlightedDays, Calendar[] highlightedDaysEnd) {
        this.mAutoHighlight = false;
        Arrays.sort(highlightedDays);
        Arrays.sort(highlightedDaysEnd);
        this.highlightedDays = highlightedDays;
        this.highlightedDaysEnd = highlightedDaysEnd;
    }

    @Override
    public Calendar[] getHighlightedDays() {
        return this.highlightedDays;
    }

    public void setSelectableDays(Calendar[] selectableDays) {
        Arrays.sort(selectableDays);
        this.selectableDays = selectableDays;
    }

    public void setSelectableDaysEnd(Calendar[] selectableDaysEnd) {
        Arrays.sort(selectableDaysEnd);
        this.selectableDaysEnd = selectableDaysEnd;
    }

    @Override
    public Calendar[] getSelectableDays() {
        return this.selectableDays;
    }

    public void setOnDateSetListener(OnDateSetListener listener) {
        this.mCallBack = listener;
    }

    public void setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
        this.mOnCancelListener = onCancelListener;
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    private void adjustDayInMonthIfNeeded(Calendar calendar) {
        int daysInMonth;
        int day = calendar.get(5);
        if (day > (daysInMonth = calendar.getActualMaximum(5))) {
            calendar.set(5, daysInMonth);
        }
    }

    public void onClick(View v) {
        this.tryVibrate();
        if (v.getId() == R.id.range_date_picker_year || v.getId() == R.id.range_date_picker_year_end) {
            this.setCurrentView(1);
        } else if (v.getId() == R.id.range_date_picker_month_and_day || v.getId() == R.id.range_date_picker_month_and_day_end) {
            this.setCurrentView(0);
        }
    }

    @Override
    public void onYearSelected(int year) {
        this.adjustDayInMonthIfNeeded(this.mCalendar);
        this.adjustDayInMonthIfNeeded(this.mCalendarEnd);
        if (this.tabHost.getCurrentTab() == 0) {
            this.mCalendar.set(1, year);
        } else {
            this.mCalendarEnd.set(1, year);
        }
        this.updatePickers();
        this.setCurrentView(0);
        this.updateDisplay(true);
    }

    @Override
    public void onDayOfMonthSelected(int year, int month, int day) {
        if (this.tabHost.getCurrentTab() == 0) {
            this.mCalendar.set(1, year);
            this.mCalendar.set(2, month);
            this.mCalendar.set(5, day);
        } else {
            this.mCalendarEnd.set(1, year);
            this.mCalendarEnd.set(2, month);
            this.mCalendarEnd.set(5, day);
        }
        if (this.mAutoHighlight) {
            this.calculateHighlightedDays();
        }
        this.updatePickers();
        this.updateDisplay(true);
    }

    private void calculateHighlightedDays() {
        int numDays = (int)Math.round((double)(this.mCalendarEnd.getTimeInMillis() - this.mCalendar.getTimeInMillis()) / 8.64E7);
        int dir = 1;
        if (numDays < 0) {
            dir = -1;
        }
        numDays = Math.abs(numDays);
        this.highlightedDays = new Calendar[numDays + 1];
        for (int i = 0; i < numDays; ++i) {
            this.highlightedDays[i] = new GregorianCalendar(this.mCalendar.get(1), this.mCalendar.get(2), this.mCalendar.get(5));
            this.highlightedDays[i].add(5, i * dir);
        }
        this.highlightedDays[numDays] = this.mCalendarEnd;
        this.highlightedDaysEnd = this.highlightedDays;
    }

    private void updatePickers() {
        for (OnDateChangedListener listener : this.mListeners) {
            listener.onDateChanged();
        }
    }

    @Override
    public MonthAdapter.CalendarDay getSelectedDay() {
        if (this.tabHost.getCurrentTab() == 0) {
            return new MonthAdapter.CalendarDay(this.mCalendar);
        }
        return new MonthAdapter.CalendarDay(this.mCalendarEnd);
    }

    @Override
    public int getMinYear() {
        if (this.selectableDays != null) {
            return this.selectableDays[0].get(1);
        }
        return this.mMinDate != null && this.mMinDate.get(1) > this.mMinYear ? this.mMinDate.get(1) : this.mMinYear;
    }

    @Override
    public int getMaxYear() {
        if (this.selectableDays != null) {
            return this.selectableDays[this.selectableDays.length - 1].get(1);
        }
        return this.mMaxDate != null && this.mMaxDate.get(1) < this.mMaxYear ? this.mMaxDate.get(1) : this.mMaxYear;
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.mWeekStart;
    }

    @Override
    public void registerOnDateChangedListener(OnDateChangedListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public void unregisterOnDateChangedListener(OnDateChangedListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public void tryVibrate() {
        if (this.mVibrate) {
            this.mHapticFeedbackController.tryVibrate();
        }
    }

    public void setStartTitle(String startTitle) {
        this.startTitle = startTitle;
    }

    public void setEndTitle(String endTitle) {
        this.endTitle = endTitle;
    }

    public static interface OnDateChangedListener {
        public void onDateChanged();
    }

    public static interface OnDateSetListener {
        public void onDateSet(DatePickerDialog var1, int var2, int var3, int var4, int var5, int var6, int var7);
    }
}

