/*
 * Decompiled with CFR 0.152.
 */
package com.borax12.materialdaterangepicker;

import android.animation.Keyframe;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;

public class Utils {
    public static final int PULSE_ANIMATOR_DURATION = 544;
    public static final int SELECTED_ALPHA = 255;
    public static final int SELECTED_ALPHA_THEME_DARK = 255;
    public static final int FULL_ALPHA = 255;

    public static boolean isJellybeanOrLater() {
        return Build.VERSION.SDK_INT >= 16;
    }

    @SuppressLint(value={"NewApi"})
    public static void tryAccessibilityAnnounce(View view, CharSequence text) {
        if (Utils.isJellybeanOrLater() && view != null && text != null) {
            view.announceForAccessibility(text);
        }
    }

    public static ObjectAnimator getPulseAnimator(View labelToAnimate, float decreaseRatio, float increaseRatio) {
        Keyframe k0 = Keyframe.ofFloat((float)0.0f, (float)1.0f);
        Keyframe k1 = Keyframe.ofFloat((float)0.275f, (float)decreaseRatio);
        Keyframe k2 = Keyframe.ofFloat((float)0.69f, (float)increaseRatio);
        Keyframe k3 = Keyframe.ofFloat((float)1.0f, (float)1.0f);
        PropertyValuesHolder scaleX = PropertyValuesHolder.ofKeyframe((String)"scaleX", (Keyframe[])new Keyframe[]{k0, k1, k2, k3});
        PropertyValuesHolder scaleY = PropertyValuesHolder.ofKeyframe((String)"scaleY", (Keyframe[])new Keyframe[]{k0, k1, k2, k3});
        ObjectAnimator pulseAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)labelToAnimate, (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleX, scaleY});
        pulseAnimator.setDuration(544L);
        return pulseAnimator;
    }

    public static int dpToPx(float dp, Resources resources) {
        float px = TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)resources.getDisplayMetrics());
        return (int)px;
    }

    public static int darkenColor(int color) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color, (float[])hsv);
        hsv[2] = hsv[2] * 0.8f;
        return Color.HSVToColor((float[])hsv);
    }

    public static int getAccentColorFromThemeIfAvailable(Context context) {
        TypedValue typedValue = new TypedValue();
        if (Build.VERSION.SDK_INT >= 21) {
            context.getTheme().resolveAttribute(16843829, typedValue, true);
            return typedValue.data;
        }
        int colorAccentResId = context.getResources().getIdentifier("colorAccent", "attr", context.getPackageName());
        if (colorAccentResId == 0) {
            return -1;
        }
        if (!context.getTheme().resolveAttribute(colorAccentResId, typedValue, true)) {
            return -1;
        }
        return typedValue.data;
    }
}

