/*
 * Decompiled with CFR 0.152.
 */
package com.bookmate.libs.epub;

import com.bookmate.libs.epub.EpubFile;
import com.bookmate.libs.epub.EpubItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class EpubItems {
    private static final String LOG_TAG = EpubItems.class.getSimpleName();
    private static final String ITEM_REFS_XPATH = "//spine/itemref";
    private static final String ITEMS_XPATH = "//item";
    private final List<EpubItem> items = new ArrayList<EpubItem>();
    private long totalSize = 0L;

    public EpubItems(EpubFile file) throws XPathExpressionException {
        Document opfXml = file.getOpf();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        NodeList itemRefs = (NodeList)xPath.evaluate(ITEM_REFS_XPATH, opfXml, XPathConstants.NODESET);
        NodeList items = (NodeList)xPath.evaluate(ITEMS_XPATH, opfXml, XPathConstants.NODESET);
        for (int i = 0; i < itemRefs.getLength(); ++i) {
            Node itemRef = itemRefs.item(i);
            String navId = itemRef.getAttributes().getNamedItem("idref").getTextContent();
            Node item = this.findItemById(items, navId);
            if (item == null) continue;
            String navPath = item.getAttributes().getNamedItem("href").getTextContent();
            long size = file.getSize(navPath);
            this.items.add(new EpubItem(navId, navPath, size, this.totalSize));
            this.totalSize += size;
        }
    }

    private Node findItemById(NodeList items, String id) {
        for (int i = 0; i < items.getLength(); ++i) {
            Node item = items.item(i);
            String itemId = item.getAttributes().getNamedItem("id").getTextContent();
            if (!id.equals(itemId)) continue;
            return item;
        }
        return null;
    }

    public int getItemsCount() {
        return this.items.size();
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public EpubItem get(int itemIndex) {
        return this.items.get(itemIndex);
    }

    private EpubItem get(String id) {
        for (EpubItem epubItem : this.items) {
            if (!epubItem.getId().equals(id)) continue;
            return epubItem;
        }
        return null;
    }

    public int getIndex(String id) {
        EpubItem epubItem = this.get(id);
        if (epubItem != null) {
            return this.items.indexOf(epubItem);
        }
        return -1;
    }

    public int getIndex(long offset) {
        return Arrays.binarySearch(this.items.toArray(), offset, new Comparator<Object>(){

            @Override
            public int compare(Object lhs, Object rhs) {
                EpubItem epubItem = (EpubItem)lhs;
                Long offset = (Long)rhs;
                return offset < epubItem.getSizeUpToThisItem() ? 1 : (offset > epubItem.getSizeUpToThisItem() + epubItem.getSize() ? -1 : 0);
            }
        });
    }

    public long sumSizes(int upToIndex) {
        long sumSizes = 0L;
        for (int i = 0; i < upToIndex; ++i) {
            sumSizes += this.get(i).getSize();
        }
        return sumSizes;
    }

    public long sumTextLengths(int upToIndex) {
        long sumTextLengths = 0L;
        for (int i = 0; i < upToIndex; ++i) {
            sumTextLengths += this.get(i).getSize();
        }
        return sumTextLengths;
    }
}

