/*
 * Decompiled with CFR 0.152.
 */
package com.bookmate.libs.epub;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.MimeTypeMap;
import android.webkit.WebResourceResponse;
import com.bookmate.libs.epub.EpubFile;
import com.bookmate.libs.epub.EpubItem;
import com.bookmate.libs.epub.EpubItems;
import com.bookmate.libs.epub.History;
import com.bookmate.libs.epub.Metadata;
import com.bookmate.libs.epub.NavPoint;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;

public class ReadingSystem {
    private static final String LOG_TAG = "reader " + ReadingSystem.class.getSimpleName();
    private static final String BOOKMARK_REGEX = "(?:d=(?:[^&]+)&)?i=([^:]+)(?::([\\d\\.]+))?";
    private static final Pattern BOOKMARK_PATTERN = Pattern.compile("(?:d=(?:[^&]+)&)?i=([^:]+)(?::([\\d\\.]+))?");
    private static final Pattern CFI_PATTERN = Pattern.compile("(\\d+)!");
    private static final String EPUB_SCHEME = "epub://root/";
    private EpubFile epubFile;
    private final History history;
    private EpubItems epubItems;
    private Metadata metadata;
    private Listener listener;
    private float progressInItem = 0.0f;
    private int currentItemIndex = 0;
    @Nullable
    private NavPoint[] chapters;

    public ReadingSystem(EpubFile file) throws XPathExpressionException {
        Log.d((String)LOG_TAG, (String)"ReadingSystem()");
        this.epubFile = file;
        this.epubItems = new EpubItems(this.epubFile);
        this.metadata = new Metadata(this.epubFile);
        this.history = new History(this);
    }

    public History history() {
        return this.history;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    private synchronized EpubFile getEpubFile() {
        return this.epubFile;
    }

    public synchronized void swapEpubFile(EpubFile file) {
        this.epubFile = file;
    }

    public int getCurrentItemIndex() {
        return this.currentItemIndex;
    }

    public boolean isLastPageInBook(int pageIndex, int pagesCount) {
        return !this.validItemIndex(this.currentItemIndex + 1) && pageIndex == pagesCount - 1;
    }

    public boolean adjustProgressToPage(int pageIndex, int pageCount) {
        return this.goTo(this.currentItemIndex, (float)pageIndex / (float)pageCount, false);
    }

    public void goToPage(int currentPageIndex, int pagesCount, boolean nextPage) {
        boolean goSuccesseful;
        int newPageIndex = currentPageIndex + (nextPage ? 1 : -1);
        if (newPageIndex >= pagesCount) {
            goSuccesseful = this.goTo(this.currentItemIndex + 1, 0.0f);
        } else {
            boolean bl = goSuccesseful = newPageIndex < 0 ? this.goTo(this.currentItemIndex - 1, 1.0f) : this.goToPageInThisItem(newPageIndex, pagesCount);
        }
        if (!goSuccesseful && nextPage && this.listener != null) {
            this.listener.onEndOfBook();
        }
    }

    public boolean goToPageInThisItem(int pageIndex, int pagesCount) {
        return this.goTo(this.currentItemIndex, (float)pageIndex / (float)pagesCount);
    }

    public void goToBookProgress(float bookProgress) {
        long wantedOffset = this.bookProgress2Offset(bookProgress);
        int itemIndex = this.epubItems.getIndex(wantedOffset);
        EpubItem epubItem = this.epubItems.get(itemIndex);
        this.goTo(itemIndex, (float)(wantedOffset - epubItem.getSizeUpToThisItem()) / (float)epubItem.getSize());
    }

    public boolean goToBookmark(String bookmark) {
        Matcher matcher;
        if (!TextUtils.isEmpty((CharSequence)bookmark) && (matcher = BOOKMARK_PATTERN.matcher(bookmark)).find()) {
            float progress;
            String itemId = matcher.group(1);
            String progressString = matcher.group(2);
            float f = progress = TextUtils.isEmpty((CharSequence)progressString) ? 0.0f : Float.valueOf(progressString).floatValue();
            if (this.goTo(itemId, progress / 100.0f)) {
                return true;
            }
        }
        return false;
    }

    private boolean goTo(String id, float progress) {
        return this.goTo(this.epubItems.getIndex(id), progress);
    }

    public boolean goTo(int itemIndex, float progress) {
        return this.goTo(itemIndex, progress, true);
    }

    private boolean goTo(int itemIndex, float progress, boolean notify) {
        if (!this.validItemIndex(itemIndex)) {
            return false;
        }
        this.currentItemIndex = itemIndex;
        this.progressInItem = this.clampProgress(progress);
        if (notify) {
            this.listener.onProgressChanged();
        }
        return true;
    }

    private float clampProgress(float progress) {
        return Math.min(1.0f, Math.max(0.0f, progress));
    }

    public int alreadyReadSize() {
        return (int)((float)this.epubItems.sumTextLengths(this.currentItemIndex) + (float)this.epubItems.get(this.getCurrentItemIndex()).getTextLength() * this.progressInItem());
    }

    public float progressInItem() {
        return this.progressInItem;
    }

    public float bookProgress() {
        return this.calcBookProgress(this.progressInItem);
    }

    public float bookProgressForDisplay(int page, int pageCount) {
        return this.calcBookProgress(pageCount == 1 ? 1.0f : (float)page / (float)(pageCount - 1));
    }

    private float calcBookProgress(float itemProgress) {
        return ((float)this.epubItems.get(this.currentItemIndex).getSize() * itemProgress + (float)this.epubItems.sumSizes(this.currentItemIndex)) * 100.0f / (float)this.epubItems.getTotalSize();
    }

    private long bookProgress2Offset(float bookProgress) {
        return (long)(this.clampProgress(bookProgress / 100.0f) * (float)this.epubItems.getTotalSize());
    }

    public boolean validItemIndex(int itemIndex) {
        return itemIndex >= 0 && itemIndex < this.epubItems.getItemsCount();
    }

    public boolean isLastPage(int pageIndex, int pageCount) {
        return this.getCurrentItemIndex() == this.epubItems.getItemsCount() - 1 && pageIndex == pageCount - 1;
    }

    private String getItemId(int itemIndex) {
        return this.epubItems.get(itemIndex).getId();
    }

    public String getCurrentItemId() {
        return this.getItemId(this.currentItemIndex);
    }

    public String getCurrentItemPath() {
        return this.getItemPath(this.currentItemIndex);
    }

    public String getItemPath(int itemIndex) {
        if (!this.validItemIndex(itemIndex)) {
            throw new IllegalArgumentException("wrong index: " + itemIndex + " items count: " + this.epubItems.getItemsCount());
        }
        return this.epubItems.get(itemIndex).getPath();
    }

    public String getItemPath(String cfi) {
        Matcher matcher;
        if (!TextUtils.isEmpty((CharSequence)cfi) && (matcher = CFI_PATTERN.matcher(cfi)).find()) {
            int itemRef = Integer.valueOf(matcher.group(1));
            return this.getItemPath(itemRef / 2 - 1);
        }
        return null;
    }

    public String getItemUrl(int itemIndex) {
        return EPUB_SCHEME + this.getItemPath(itemIndex);
    }

    public boolean isInternalLink(String url) {
        return url.startsWith(EPUB_SCHEME);
    }

    public WebResourceResponse getWebResource(String url) {
        Log.d((String)LOG_TAG, (String)("getResource " + url));
        String fileName = url.substring(EPUB_SCHEME.length());
        try {
            String mimeType = null;
            String extension = MimeTypeMap.getFileExtensionFromUrl((String)fileName);
            if (extension != null) {
                MimeTypeMap mime = MimeTypeMap.getSingleton();
                mimeType = mime.getMimeTypeFromExtension(extension);
            }
            return new WebResourceResponse(mimeType, "utf-8", this.getInputStream(fileName));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getItemHtml(int itemIndex) {
        try {
            InputStream stream = this.getInputStream(this.getItemPath(itemIndex));
            if (stream != null) {
                return IOUtils.toString((InputStream)stream, (String)"utf-8");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public InputStream getInputStream(String fileName) throws IOException {
        return this.getEpubFile().getStream(fileName);
    }

    public void cacheItemData() {
        this.getEpubFile().loadStream(this.getCurrentItemPath());
    }

    public boolean isCurrentItemEmpty() {
        return this.getEpubFile().isItemStreamEmpty(this.getCurrentItemPath());
    }

    public String generateCfi(String startCfi, String endCfi) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        Document opfXml = this.getEpubFile().getOpf();
        String XPATH_EXPRESSION = "count(/package/spine/preceding-sibling::*)";
        int spineNumber = (((Double)xPath.evaluate(XPATH_EXPRESSION, opfXml, XPathConstants.NUMBER)).intValue() + 1) * 2;
        XPATH_EXPRESSION = "/package/spine//itemref[" + this.currentItemIndex + "]/@id";
        String itemRefId = (String)xPath.evaluate(XPATH_EXPRESSION, opfXml, XPathConstants.STRING);
        itemRefId = TextUtils.isEmpty((CharSequence)itemRefId) ? "" : "[" + itemRefId + "]";
        int itemRefNumber = (this.currentItemIndex + 1) * 2;
        return "/" + spineNumber + "/" + itemRefNumber + itemRefId + "!/," + startCfi + "," + endCfi;
    }

    public String generateBookmark(String epubName) {
        return "d=" + epubName + "&i=" + this.getCurrentItemId() + ":" + this.progressInItem * 100.0f;
    }

    public int getCachedTextLength(int itemIndex) {
        return this.epubItems.get(itemIndex).getTextLength();
    }

    public void cacheTextLength(int itemIndex, int textLength) {
        this.epubItems.get(itemIndex).setTextLength(textLength);
    }

    public static String getOpfItemIdByBookmark(String bookmark) {
        Matcher matcher = BOOKMARK_PATTERN.matcher(bookmark);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private NavPoint[] lazyGetChapters() {
        if (this.chapters == null) {
            this.chapters = this.metadata.parseChapters();
        }
        return this.chapters;
    }

    private NavPoint getChapter(int itemIndex) {
        NavPoint[] chapters = this.lazyGetChapters();
        int chapterIndex = this.metadata.getItemIndex(this.getItemId(itemIndex));
        if (chapters == null || chapters.length <= chapterIndex) {
            return null;
        }
        return chapters[chapterIndex];
    }

    public String getCurrentChapterTitle() {
        return this.getChapterTitle(this.currentItemIndex);
    }

    public String getChapterTitleByProgress(int progress) {
        return this.getChapterTitle(this.epubItems.getIndex(this.bookProgress2Offset(progress)));
    }

    private String getChapterTitle(int itemIndex) {
        NavPoint chapter = this.getChapter(itemIndex);
        return chapter == null ? null : chapter.getTitle();
    }

    public static interface Listener {
        public void onProgressChanged();

        public void onEndOfBook();
    }
}

