/*
 * Decompiled with CFR 0.152.
 */
package com.bookmate.libs.epub;

import android.text.TextUtils;
import com.bookmate.libs.epub.EpubFile;
import com.bookmate.libs.epub.NavPoint;
import java.util.ArrayList;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Metadata {
    private static final String LOG_TAG = Metadata.class.getSimpleName();
    private final EpubFile file;
    private ArrayList<NavPoint> tocList;

    public Metadata(EpubFile file) {
        this.file = file;
    }

    private XPath initXpath() {
        XPathFactory factory = XPathFactory.newInstance();
        return factory.newXPath();
    }

    public NavPoint[] parseChapters() {
        Document tocDocument = this.file.getNcx();
        this.tocList = new ArrayList();
        if (tocDocument == null) {
            return null;
        }
        NodeList navMaps = tocDocument.getElementsByTagName("navMap");
        for (int i = 0; i < navMaps.getLength(); ++i) {
            Element navMap = (Element)navMaps.item(i);
            this.parseRecursively(navMap, 0);
        }
        NavPoint[] navPoints = new NavPoint[this.tocList.size()];
        for (int i = 0; i < this.tocList.size(); ++i) {
            navPoints[i] = this.tocList.get(i);
        }
        return navPoints;
    }

    private void parseRecursively(Element navMap, int depth) {
        NodeList list = navMap.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            String name = list.item(i).getNodeName();
            if (!"navPoint".equals(name) && !"navList".equals(name) && !"pageList".equals(name)) continue;
            this.tocList.add(this.createNavPoint((Element)list.item(i), depth));
            this.parseRecursively((Element)list.item(i), depth + 1);
        }
    }

    private NavPoint createNavPoint(Element navPoint, int depth) {
        String id = navPoint.getAttribute("id");
        Element navLabel = (Element)navPoint.getElementsByTagName("navLabel").item(0);
        Element text = (Element)navLabel.getElementsByTagName("text").item(0);
        String tocTitle = text.getTextContent();
        Element content = (Element)navPoint.getElementsByTagName("content").item(0);
        String src = content.getAttribute("src");
        return new NavPoint(id, tocTitle, src, depth);
    }

    public String getBookmark(String epubName, int position) {
        if (this.tocList != null) {
            int dotIndex = this.tocList.get(position).getContent().indexOf(".");
            String item = this.tocList.get(position).getContent().substring(0, dotIndex);
            return "d=" + epubName + "&i=" + item + ":0";
        }
        return null;
    }

    public int getItemIndex(String opfItemId) {
        XPath xPath = this.initXpath();
        try {
            String pattern = "//manifest/item[@id=\"" + opfItemId + "\"]/@href";
            String opfItemPath = (String)xPath.evaluate(pattern, this.file.getOpf(), XPathConstants.STRING);
            pattern = "//navPoint[content[@src='" + opfItemPath + "']]/@id";
            String itemId = (String)xPath.evaluate(pattern, this.file.getNcx(), XPathConstants.STRING);
            int index = 0;
            for (NavPoint item : this.tocList) {
                if (TextUtils.equals((CharSequence)itemId, (CharSequence)item.getId())) break;
                ++index;
            }
            return index;
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return 0;
        }
    }
}

