/*
 * Decompiled with CFR 0.152.
 */
package com.bookmate.libs.epub;

import com.bookmate.libs.epub.ReadingSystem;
import java.util.ArrayList;

public class History {
    private static final String LOG_TAG = History.class.getCanonicalName();
    private int index = -1;
    private final ArrayList<ReadState> history = new ArrayList();
    private boolean shouldUpdateHistory = true;
    private final ReadingSystem readingSystem;
    private Listener listener;

    public History(ReadingSystem readingSystem) {
        this.readingSystem = readingSystem;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public ReadState getCurrentState() {
        return this.index >= 0 ? this.history.get(this.index) : null;
    }

    public boolean canGoBack() {
        return this.index > 0;
    }

    public boolean canGoForward() {
        return this.index < this.history.size() - 1;
    }

    public void back() {
        if (this.canGoBack()) {
            this.move(false);
        }
    }

    public void forward() {
        if (this.canGoForward()) {
            this.move(true);
        }
    }

    private void move(boolean forward) {
        this.index += forward ? 1 : -1;
        this.notifyCurrentState();
        this.shouldUpdateHistory = false;
    }

    public void notifyCurrentState() {
        this.listener.onHistoryMove(this.getCurrentState());
    }

    public void updateCurrentState() {
        if (this.shouldUpdateHistory) {
            this.updateCurrentState(new ReadState(this.readingSystem));
        } else {
            this.shouldUpdateHistory = true;
        }
    }

    private void updateCurrentState(ReadState state) {
        if (this.index >= 0) {
            this.clearForwardHistory();
            this.history.remove(this.index);
            this.history.add(this.index, state);
        } else {
            ++this.index;
            this.history.add(state);
        }
    }

    public void pushState() {
        this.pushState(new ReadState(this.readingSystem));
    }

    private void pushState(ReadState state) {
        ++this.index;
        if (this.index < this.history.size()) {
            this.history.remove(this.index);
            this.history.add(this.index, state);
            this.clearForwardHistory();
        } else {
            this.history.add(state);
        }
        this.listener.onHistoryPushState();
    }

    public void clearForwardHistory() {
        int maxIndex = this.history.size() - 1;
        while (this.history.size() > this.index + 1) {
            this.history.remove(maxIndex);
            maxIndex = this.history.size() - 1;
        }
    }

    public static interface Listener {
        public void onHistoryMove(ReadState var1);

        public void onHistoryPushState();
    }

    public static class ReadState {
        private final int itemIndex;
        private final float progress;

        public ReadState(ReadingSystem readingSystem) {
            this(readingSystem.getCurrentItemIndex(), readingSystem.progressInItem());
        }

        public ReadState(int itemIndex, float progress) {
            this.itemIndex = itemIndex;
            this.progress = progress;
        }

        public int getItemIndex() {
            return this.itemIndex;
        }

        public float getProgress() {
            return this.progress;
        }

        public String toString() {
            return this.itemIndex + "_" + this.progress;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadState)) {
                return false;
            }
            ReadState rs = (ReadState)o;
            return rs.itemIndex == this.itemIndex && rs.progress == this.progress;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.itemIndex;
            result = 31 * result + (int)(this.progress * 1000.0f);
            return result;
        }
    }
}

