/*
 * Decompiled with CFR 0.152.
 */
package com.bookmate.libs.epub;

import android.text.TextUtils;
import android.util.Base64;
import com.bookmate.libs.epub.DocumentMetadata;
import com.bookmate.libs.epub.EpubFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URLDecoder;
import java.security.Key;
import java.util.Arrays;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class EpubRemoteFile
implements EpubFile {
    private static final String LOG_TAG = EpubRemoteFile.class.getSimpleName();
    private final String mSecret;
    private final Api api;
    private final String mContainer;
    private final String mOpf;
    private final String mNcx;
    private String mRootPath;
    private String mOpfPath;
    private final HashMap<String, Long> mSizes;
    private DocumentBuilder mBuilder;
    private XPath mXPath;
    private InputStream cachedStream;
    private String cachedStreamName;
    private int cachedStreamSize;

    public EpubRemoteFile(String secret, Api api) {
        this.mSecret = secret;
        this.api = api;
        DocumentMetadata metadata = api.getDocumentMetadata();
        this.mContainer = this.decrypt(metadata.container);
        this.mOpf = this.decrypt(metadata.opf);
        this.mNcx = this.decrypt(metadata.ncx);
        this.mSizes = metadata.sizes;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            this.mBuilder = dbFactory.newDocumentBuilder();
            XPathFactory factory = XPathFactory.newInstance();
            this.mXPath = factory.newXPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String decrypt(byte[] data) {
        String decrypted = null;
        try {
            if (this.mSecret == null) {
                decrypted = new String(data, "UTF-8");
            } else {
                byte[] ivBytes = Arrays.copyOf(data, 16);
                byte[] contentBytes = Arrays.copyOfRange(data, 16, data.length);
                byte[] secretBytes = Base64.decode((String)this.mSecret, (int)0);
                IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
                SecretKeySpec newKey = new SecretKeySpec(secretBytes, "AES");
                Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
                cipher.init(2, (Key)newKey, ivSpec);
                decrypted = new String(cipher.doFinal(contentBytes), "UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return decrypted;
    }

    @Override
    public long getSize(String name) {
        return this.mSizes.get(this.getFilePath(name));
    }

    private String getRootPath() {
        if (this.mRootPath == null) {
            this.mRootPath = FilenameUtils.getPath((String)this.getOpfPath());
        }
        return this.mRootPath;
    }

    private String getOpfPath() {
        if (this.mOpfPath != null) {
            return this.mOpfPath;
        }
        try {
            Document doc = this.getContainer();
            this.mOpfPath = this.mXPath.evaluate("//rootfile[@media-type='application/oebps-package+xml']/@full-path", doc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.mOpfPath;
    }

    private String getFilePath(String name) {
        String decodedName = name;
        try {
            decodedName = URLDecoder.decode(name, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return FilenameUtils.concat((String)this.getRootPath(), (String)decodedName);
    }

    @Override
    public Document getOpf() {
        Document doc = null;
        try {
            doc = this.mBuilder.parse(new InputSource(new StringReader(this.mOpf)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    @Override
    public Document getNcx() {
        Document doc = null;
        try {
            doc = this.mBuilder.parse(new InputSource(new StringReader(this.mNcx)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    private Document getContainer() {
        Document doc = null;
        try {
            doc = this.mBuilder.parse(new InputSource(new StringReader(this.mContainer)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    @Override
    public InputStream getStream(String name) throws IOException {
        this.loadStream(name);
        return this.cachedStream;
    }

    @Override
    public void loadStream(String name) {
        if (!this.isItemCached(name)) {
            this.cacheStream(name);
        }
    }

    private void cacheStream(String name) {
        if (this.cachedStream != null) {
            IOUtils.closeQuietly((InputStream)this.cachedStream);
        }
        try {
            this.cachedStream = this.api.loadStreamFromServer(this.getFilePath(name));
            this.cachedStreamName = name;
            this.cachedStreamSize = this.cachedStream == null ? 0 : this.cachedStream.available();
        }
        catch (IOException e) {
            this.cachedStream = null;
            this.cachedStreamName = null;
            this.cachedStreamSize = 0;
        }
    }

    @Override
    public boolean isItemStreamEmpty(String name) {
        return this.isItemCached(name) && this.cachedStreamSize == 0;
    }

    private boolean isItemCached(String name) {
        return TextUtils.equals((CharSequence)this.cachedStreamName, (CharSequence)name) && this.cachedStream != null;
    }

    public static interface Api {
        public DocumentMetadata getDocumentMetadata();

        public InputStream loadStreamFromServer(String var1) throws IOException;
    }
}

