/*
 * Decompiled with CFR 0.152.
 */
package com.bookmate.libs.epub;

import android.content.res.Resources;
import android.graphics.drawable.BitmapDrawable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Base64;
import com.bookmate.libs.epub.EpubFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URLDecoder;
import java.security.Key;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EpubLocalFile
implements EpubFile {
    private static final String LOG_TAG = EpubLocalFile.class.getSimpleName();
    private final String absolutePath;
    private ZipFile mZipFile;
    private String mSecret;
    private DocumentBuilder mBuilder;
    private XPath mXPath;
    private String mOpfPath;
    private String mNcxPath;
    private String mRootPath;
    private Document mOpf;
    private Document mNcx;

    public EpubLocalFile(File file, String secret) throws IOException {
        this.mZipFile = new ZipFile(file);
        this.mSecret = secret;
        this.absolutePath = file.getAbsolutePath();
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            this.mBuilder = dbFactory.newDocumentBuilder();
            XPathFactory factory = XPathFactory.newInstance();
            this.mXPath = factory.newXPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getRootPath() {
        if (this.mRootPath == null) {
            this.mRootPath = FilenameUtils.getPath((String)this.getOpfPath());
        }
        return this.mRootPath;
    }

    private ZipEntry getEntry(String name) {
        return this.getEntry(name, false);
    }

    private ZipEntry getEntry(String name, boolean isRoot) {
        String decodedName = name;
        try {
            decodedName = URLDecoder.decode(name, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (isRoot) {
            return this.mZipFile.getEntry(decodedName);
        }
        String filePath = FilenameUtils.concat((String)this.getRootPath(), (String)decodedName);
        return this.mZipFile.getEntry(filePath);
    }

    @Override
    public InputStream getStream(String name) throws IOException {
        return this.getStream(name, false);
    }

    private InputStream getStream(String name, boolean isRoot) throws IOException {
        ZipEntry entry = this.getEntry(name, isRoot);
        return IOUtils.toBufferedInputStream((InputStream)this.mZipFile.getInputStream(entry));
    }

    @Override
    public long getSize(String name) {
        ZipEntry entry = this.getEntry(name);
        return entry.getSize();
    }

    private Document getContainer() {
        return this.getDocumentFromZip("META-INF/container.xml");
    }

    private String getOpfPath() {
        if (this.mOpfPath != null) {
            return this.mOpfPath;
        }
        try {
            Document doc = this.getContainer();
            this.mOpfPath = this.mXPath.evaluate("//rootfile[@media-type='application/oebps-package+xml']/@full-path", doc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.mOpfPath;
    }

    @Override
    public Document getOpf() {
        if (this.mOpf != null) {
            return this.mOpf;
        }
        this.mOpf = this.getDocumentFromZip(this.getOpfPath());
        return this.mOpf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocumentFromZip(String path) {
        InputStream stream = null;
        Document document = null;
        try {
            stream = this.getStream(path, true);
            document = this.streamToDocument(stream);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)stream);
        }
        IOUtils.closeQuietly((InputStream)stream);
        return document;
    }

    private String getNcxPath() {
        if (this.mNcxPath != null) {
            return this.mNcxPath;
        }
        try {
            Document doc = this.getOpf();
            String ncxPath = this.mXPath.evaluate("//item[@media-type='application/x-dtbncx+xml']/@href", doc);
            this.mNcxPath = FilenameUtils.concat((String)this.getRootPath(), (String)ncxPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.mNcxPath;
    }

    @Override
    public Document getNcx() {
        if (this.mNcx != null) {
            return this.mNcx;
        }
        this.mNcx = this.getDocumentFromZip(this.getNcxPath());
        return this.mNcx;
    }

    @Override
    public void loadStream(String name) {
    }

    @Override
    public boolean isItemStreamEmpty(String name) {
        return false;
    }

    private Document streamToDocument(InputStream stream) throws IOException, SAXException {
        if (this.mSecret == null) {
            return this.mBuilder.parse(stream);
        }
        String xml = this.decrypt(IOUtils.toByteArray((InputStream)stream));
        InputSource is = new InputSource(new StringReader(xml));
        return this.mBuilder.parse(is);
    }

    private String decrypt(byte[] data) {
        String decrypted = null;
        try {
            if (this.mSecret == null) {
                decrypted = new String(data, "UTF-8");
            } else {
                byte[] ivBytes = Arrays.copyOf(data, 16);
                byte[] contentBytes = Arrays.copyOfRange(data, 16, data.length);
                byte[] secretBytes = Base64.decode((String)this.mSecret, (int)0);
                IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
                SecretKeySpec newKey = new SecretKeySpec(secretBytes, "AES");
                Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
                cipher.init(2, (Key)newKey, ivSpec);
                decrypted = new String(cipher.doFinal(contentBytes), "UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return decrypted;
    }

    @Nullable
    public BitmapDrawable getCover(Resources resources) {
        String coverUrl = this.findCoverUrl();
        if (!TextUtils.isEmpty((CharSequence)coverUrl)) {
            try {
                return new BitmapDrawable(resources, this.getStream(coverUrl));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String findCoverUrl() {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        try {
            String pattern = "//guide/reference[@type=\"cover\"]/@href";
            String coverUri = (String)xPath.evaluate(pattern, this.getOpf(), XPathConstants.STRING);
            if (coverUri.contains("html")) {
                return (String)this.mXPath.evaluate("//img/@src", this.getDocumentFromZip(this.getRootPath() + coverUri), XPathConstants.STRING);
            }
            return coverUri;
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
    }
}

