/*
 * Decompiled with CFR 0.152.
 */
package com.bonitasoft.gradle.maven.settings;

import com.bonitasoft.gradle.maven.settings.MavenSettingsPluginExtension;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.building.SettingsProblem;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000fH\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\f\u0010\u0016\u001a\u00020\u0015*\u00020\u0015H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/bonitasoft/gradle/maven/settings/LocalMavenSettingsLoader;", "", "extension", "Lcom/bonitasoft/gradle/maven/settings/MavenSettingsPluginExtension;", "logger", "Lorg/gradle/api/logging/Logger;", "(Lcom/bonitasoft/gradle/maven/settings/MavenSettingsPluginExtension;Lorg/gradle/api/logging/Logger;)V", "cipher", "Lorg/sonatype/plexus/components/cipher/DefaultPlexusCipher;", "globalSettingsFile", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "settingsSecurityFile", "Ljava/io/File;", "handlePasswordDecryption", "", "server", "Lorg/apache/maven/settings/Server;", "password", "masterPassword", "loadSettings", "Lorg/apache/maven/settings/Settings;", "decryptCredentials", "maven-settings-plugin"})
public final class LocalMavenSettingsLoader {
    private final Path globalSettingsFile;
    private final File settingsSecurityFile;
    private final DefaultPlexusCipher cipher;
    private final MavenSettingsPluginExtension extension;
    private final Logger logger;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Settings loadSettings() {
        SettingsBuildingResult settingsBuildingResult;
        void $this$apply;
        DefaultSettingsBuildingRequest defaultSettingsBuildingRequest = new DefaultSettingsBuildingRequest();
        boolean bl = false;
        boolean bl2 = false;
        DefaultSettingsBuildingRequest defaultSettingsBuildingRequest2 = defaultSettingsBuildingRequest;
        DefaultSettingsBuilder defaultSettingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
        boolean bl3 = false;
        $this$apply.setUserSettingsFile(this.extension.getUserSettingsFile());
        $this$apply.setGlobalSettingsFile(this.globalSettingsFile.toFile());
        $this$apply.setSystemProperties(System.getProperties());
        if ($this$apply.getGlobalSettingsFile().exists()) {
            StringBuilder stringBuilder = new StringBuilder().append("Using maven global settings.xml: ");
            File file = $this$apply.getGlobalSettingsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"globalSettingsFile");
            this.logger.info(stringBuilder.append(file.getAbsolutePath()).toString());
        }
        if ($this$apply.getUserSettingsFile().exists()) {
            StringBuilder stringBuilder = new StringBuilder().append("Using maven user settings.xml does not exists: ");
            File file = $this$apply.getUserSettingsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"userSettingsFile");
            this.logger.info(stringBuilder.append(file.getAbsolutePath()).toString());
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("No maven user settings.xml does not exists: ");
            File file = $this$apply.getUserSettingsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"userSettingsFile");
            this.logger.info(stringBuilder.append(file.getAbsolutePath()).toString());
        }
        Unit unit = Unit.INSTANCE;
        SettingsBuildingResult settingsBuildingResult2 = settingsBuildingResult = defaultSettingsBuilder.build((SettingsBuildingRequest)defaultSettingsBuildingRequest);
        Intrinsics.checkNotNullExpressionValue((Object)settingsBuildingResult2, (String)"settingsBuildingResult");
        List list = settingsBuildingResult2.getProblems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"settingsBuildingResult.problems");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SettingsProblem it = (SettingsProblem)element$iv;
            boolean bl4 = false;
            this.logger.warn("Maven: " + it);
        }
        Settings settings = settingsBuildingResult.getEffectiveSettings();
        Intrinsics.checkNotNullExpressionValue((Object)settings, (String)"settingsBuildingResult.effectiveSettings");
        return this.decryptCredentials(settings);
    }

    private final Settings decryptCredentials(Settings $this$decryptCredentials) {
        String string;
        if (this.settingsSecurityFile.exists() && !this.settingsSecurityFile.isDirectory()) {
            String string2;
            try {
                SettingsSecurity settingsSecurity = SecUtil.read((String)this.settingsSecurityFile.getAbsolutePath(), (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)settingsSecurity, (String)"SecUtil.read(settingsSec\u2026yFile.absolutePath, true)");
                string2 = this.cipher.decryptDecorated(settingsSecurity.getMaster(), "settings.security");
            }
            catch (Exception e) {
                this.logger.warn("Unable to decrypt master password provided in settings-security.xml file, use '--debug' to have the details: " + e.getMessage());
                return $this$decryptCredentials;
            }
            string = string2;
        } else {
            string = null;
        }
        String masterPassword = string;
        List list = $this$decryptCredentials.getServers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"servers");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Server server = (Server)element$iv;
            boolean bl = false;
            try {
                String $this$apply;
                String string3;
                boolean bl2;
                boolean bl3;
                StringBuilder stringBuilder = new StringBuilder().append("Processing credentials for server ");
                Server server2 = server;
                Intrinsics.checkNotNullExpressionValue((Object)server2, (String)"server");
                this.logger.debug(stringBuilder.append(server2.getId()).toString());
                if (server.getPassword() != null) {
                    bl3 = false;
                    bl2 = false;
                    $this$apply = string3;
                    boolean bl4 = false;
                    server.setPassword(this.handlePasswordDecryption(server, $this$apply, masterPassword));
                }
                if (server.getPassphrase() == null) continue;
                bl3 = false;
                bl2 = false;
                $this$apply = string3;
                boolean bl5 = false;
                server.setPassphrase(this.handlePasswordDecryption(server, $this$apply, masterPassword));
            }
            catch (Exception e) {
                StringBuilder stringBuilder = new StringBuilder().append("It looks like the password provided for the server ");
                Server server3 = server;
                Intrinsics.checkNotNullExpressionValue((Object)server3, (String)"server");
                this.logger.warn(stringBuilder.append(server3.getId()).append(" is encrypted but we are unable to decrypt it, use '--debug' to have the details: ").append(e.getMessage()).toString());
                this.logger.debug("Error while decrypting password:", (Throwable)e);
            }
        }
        return $this$decryptCredentials;
    }

    private final String handlePasswordDecryption(Server server, String password, String masterPassword) {
        if (StringsKt.startsWith$default((String)password, (String)"${env.", (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder = new StringBuilder().append("It looks like the password provided for the server ").append(server.getId()).append(" uses an unknown env variable ");
            String string = password;
            int n = "${env.".length();
            int n2 = password.length() - 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            this.logger.warn(stringBuilder.append(string3).toString());
        } else if (this.cipher.isEncryptedString(password)) {
            if (masterPassword == null) {
                this.logger.warn("It looks like the password provided for the server " + server.getId() + " is encrypted but there is no settings-security.xml file with a master password.");
                return password;
            }
            String decryptDecorated = this.cipher.decryptDecorated(password, masterPassword);
            this.logger.debug("Successfully decrypted password/passphrase for server " + server.getId());
            String string = decryptDecorated;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decryptDecorated");
            return string;
        }
        return password;
    }

    public LocalMavenSettingsLoader(@NotNull MavenSettingsPluginExtension extension, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.extension = extension;
        this.logger = logger;
        String string = System.getenv("M2_HOME");
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        this.globalSettingsFile = new File(string2).toPath().resolve("conf").resolve("settings.xml");
        string = System.getProperty("user.home");
        bl = false;
        String string3 = string;
        if (string3 == null) {
            string3 = "";
        }
        this.settingsSecurityFile = FilesKt.resolve((File)FilesKt.resolve((File)new File(string3), (String)".m2"), (String)"settings-security.xml");
        this.cipher = new DefaultPlexusCipher();
    }
}

