/*
 * Decompiled with CFR 0.152.
 */
package com.bol.openapi;

public class HealthStatus {
    private final boolean healthy;
    private String message;

    public HealthStatus(Status status) {
        this.healthy = Status.HEALTHY.equals((Object)status);
        this.message = "";
    }

    public HealthStatus(Status status, String message) {
        this(status);
        this.message = message;
    }

    public boolean isHealthy() {
        return this.healthy;
    }

    public String getMessage() {
        return this.message;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        public HealthStatus isHealthy() {
            return new HealthStatus(Status.HEALTHY);
        }

        public HealthStatus isUnhealthy(String message) {
            return new HealthStatus(Status.UNHEALTY, message);
        }
    }

    static enum Status {
        HEALTHY,
        UNHEALTY;

    }
}

