/*
 * Decompiled with CFR 0.152.
 */
package com.bol.openapi;

public class QuerySortingMethod {
    private final String sortingMethod;

    private QuerySortingMethod(String sortingMethod) {
        this.sortingMethod = sortingMethod;
    }

    public String toString() {
        return this.sortingMethod;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class SortBuilder {
        private final SortingBy by;

        private SortBuilder(SortingBy by) {
            this.by = by;
        }

        public QuerySortingMethod order(SortingOrder order) {
            StringBuilder sortingMethod = new StringBuilder();
            sortingMethod.append(this.by.getValue());
            sortingMethod.append(order.getValue());
            return new QuerySortingMethod(sortingMethod.toString());
        }
    }

    public static class Builder {
        private Builder() {
        }

        public SortBuilder by(SortingBy by) {
            return new SortBuilder(by);
        }
    }

    public static enum SortingOrder {
        ASCENDING("asc"),
        DESCENDING("desc");

        private final String value;

        private SortingOrder(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum SortingBy {
        RANK("rank"),
        PRICE("price"),
        TITLE("title"),
        DATE("date"),
        RATING("rating");

        private final String value;

        private SortingBy(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

