/*
 * Decompiled with CFR 0.152.
 */
package com.bol.openapi;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class QueryOfferType {
    private final Set<String> types = new LinkedHashSet<String>();

    private QueryOfferType(Set<String> types) {
        this.types.addAll(types);
    }

    public String toString() {
        return StringUtils.join(this.types, (String)",");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Set<String> types = new LinkedHashSet<String>();

        private Builder() {
        }

        public Builder add(OfferType type) {
            this.types.add(type.getQueryValue());
            return this;
        }

        public QueryOfferType create() {
            return new QueryOfferType(this.types);
        }
    }

    public static enum OfferType {
        ALL("all"),
        BOLCOM("bolcom"),
        CHEAPEST("cheapest"),
        NEW("newoffers"),
        SECONDHAND("2ndHand");

        private final String queryValue;

        private OfferType(String queryValue) {
            this.queryValue = queryValue;
        }

        public String getQueryValue() {
            return this.queryValue;
        }
    }
}

