/*
 * Decompiled with CFR 0.152.
 */
package com.bol.openapi;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class QueryDataType {
    private final Set<String> types = new LinkedHashSet<String>();

    private QueryDataType(Set<String> types) {
        this.types.addAll(types);
    }

    public String toString() {
        return StringUtils.join(this.types, (String)",");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Set<String> types = new LinkedHashSet<String>();

        private Builder() {
        }

        public Builder add(DataType type) {
            this.types.add(type.getQueryValue());
            return this;
        }

        public QueryDataType create() {
            return new QueryDataType(this.types);
        }
    }

    public static enum DataType {
        PRODUCTS("products"),
        CATEGORIES("categories"),
        REFINEMENTS("refinements");

        private final String queryValue;

        private DataType(String queryValue) {
            this.queryValue = queryValue;
        }

        public String getQueryValue() {
            return this.queryValue;
        }
    }
}

