/*
 * Decompiled with CFR 0.152.
 */
package com.bogdanstanga.httphelper;

import android.os.AsyncTask;
import android.util.Log;
import com.bogdanstanga.httphelper.interfaces.OnRequestListener;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.IOUtils;

public class HttpRequest
extends AsyncTask<Void, Integer, Object> {
    private String mUrl;
    private String mMethod = "GET";
    private HashMap<String, String> mParameters = new HashMap();
    private HashMap<String, String> mHeaders = new HashMap();
    private boolean mGZIPDecoding = false;
    private String mLogTag;
    private OnRequestListener mOnRequestListener;
    private static final String ENCODING = "UTF-8";

    public void setUrl(String url) {
        this.mUrl = url;
    }

    public void setMethod(String method) {
        this.mMethod = method;
    }

    public void setListener(OnRequestListener onRequestListener) {
        this.mOnRequestListener = onRequestListener;
    }

    public void setLog(String logTag) {
        this.mLogTag = logTag;
    }

    public void addParameter(String key, String value) {
        this.mParameters.put(key, value);
    }

    public void addHeader(String key, String header) {
        this.mHeaders.put(key, header);
    }

    public void setGZIPDecoding(boolean gzipDecoding) {
        this.mGZIPDecoding = gzipDecoding;
    }

    public void load() throws RuntimeException {
        if (this.mUrl == null) {
            throw new RuntimeException("The http request does not have any URL specified.");
        }
        this.execute(new Void[0]);
    }

    public String loadNonAsync() throws IOException {
        if (this.mUrl == null) {
            throw new RuntimeException("The http request does not have any URL specified.");
        }
        return this.executeRequest();
    }

    protected Object doInBackground(Void ... parameters) {
        try {
            return this.executeRequest();
        }
        catch (Exception e) {
            return e;
        }
    }

    private String executeRequest() throws IOException {
        String params;
        if (this.mMethod.equalsIgnoreCase("GET") && (params = this.getRequestParams()).length() > 0) {
            this.mUrl = this.mUrl + "?" + params;
        }
        String log = this.mMethod + "\n" + this.mUrl;
        URL url = new URL(this.mUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        for (Map.Entry<String, String> entry : this.mHeaders.entrySet()) {
            conn.setRequestProperty(entry.getKey(), entry.getValue());
        }
        conn.setDoInput(true);
        conn.setDoOutput(false);
        if (this.mMethod.equalsIgnoreCase("POST")) {
            conn.setConnectTimeout(60000);
            conn.setRequestMethod(this.mMethod);
            OutputStream os = conn.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, ENCODING));
            String params2 = this.getRequestParams();
            writer.write(params2);
            writer.flush();
            writer.close();
            os.close();
            log = log + "\n" + params2.replaceAll("=", "\n");
        }
        if (this.mLogTag != null) {
            Log.i((String)this.mLogTag, (String)log);
        }
        conn.connect();
        BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
        String stringResult = this.mGZIPDecoding ? HttpRequest.decodeGZIP(in) : IOUtils.toString((InputStream)in, (String)ENCODING);
        conn.disconnect();
        return stringResult;
    }

    protected void onPostExecute(Object object) {
        super.onPostExecute(object);
        if (object instanceof Exception) {
            Exception e = (Exception)object;
            e.printStackTrace();
            if (this.mOnRequestListener != null) {
                this.mOnRequestListener.onFailure(e);
            }
        } else if (this.mOnRequestListener != null) {
            this.mOnRequestListener.onSuccess((String)object);
        }
    }

    private String getRequestParams() throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : this.mParameters.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(entry.getKey(), ENCODING));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), ENCODING));
        }
        return result.toString();
    }

    public static String decodeGZIP(InputStream inputStream) throws IOException {
        int b;
        InflaterInputStream in = new InflaterInputStream(inputStream);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(512);
        while ((b = in.read()) != -1) {
            bout.write(b);
        }
        bout.close();
        return bout.toString();
    }
}

