/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.OneDReader;
import java.util.Hashtable;

public final class CodaBarReader
extends OneDReader {
    private static final String ALPHABET_STRING = "0123456789-$:/.+ABCDTN";
    private static final char[] ALPHABET = "0123456789-$:/.+ABCDTN".toCharArray();
    private static final int[] CHARACTER_ENCODINGS = new int[]{3, 6, 9, 96, 18, 66, 33, 36, 48, 72, 12, 24, 37, 81, 84, 21, 26, 41, 11, 14, 26, 41};
    private static final int minCharacterLength = 6;
    private static final char[] STARTEND_ENCODING = new char[]{'E', '*', 'A', 'B', 'C', 'D', 'T', 'N'};

    public Result decodeRow(int rowNumber, BitArray row, Hashtable hints) throws NotFoundException {
        int i;
        int lastStart;
        int[] counters;
        int nextStart;
        int[] start = CodaBarReader.findAsteriskPattern(row);
        start[1] = 0;
        int end = row.getSize();
        for (nextStart = start[1]; nextStart < end && !row.get(nextStart); ++nextStart) {
        }
        StringBuffer result = new StringBuffer();
        do {
            counters = new int[]{0, 0, 0, 0, 0, 0, 0};
            CodaBarReader.recordPattern(row, nextStart, counters);
            char decodedChar = CodaBarReader.toNarrowWidePattern(counters);
            if (decodedChar == '!') {
                throw NotFoundException.getNotFoundInstance();
            }
            result.append(decodedChar);
            lastStart = nextStart;
            for (i = 0; i < counters.length; ++i) {
                nextStart += counters[i];
            }
            while (nextStart < end && !row.get(nextStart)) {
                ++nextStart;
            }
        } while (nextStart < end);
        int lastPatternSize = 0;
        for (i = 0; i < counters.length; ++i) {
            lastPatternSize += counters[i];
        }
        int whiteSpaceAfterEnd = nextStart - lastStart - lastPatternSize;
        if (nextStart != end && whiteSpaceAfterEnd / 2 < lastPatternSize) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (result.length() < 2) {
            throw NotFoundException.getNotFoundInstance();
        }
        char startchar = result.charAt(0);
        if (!CodaBarReader.arrayContains(STARTEND_ENCODING, startchar)) {
            throw NotFoundException.getNotFoundInstance();
        }
        for (int k = 1; k < result.length(); ++k) {
            if (result.charAt(k) != startchar || k + 1 == result.length()) continue;
            result.delete(k + 1, result.length() - 1);
            k = result.length();
        }
        if (result.length() <= 6) {
            throw NotFoundException.getNotFoundInstance();
        }
        result.deleteCharAt(result.length() - 1);
        result.deleteCharAt(0);
        float left = (float)(start[1] + start[0]) / 2.0f;
        float right = (float)(nextStart + lastStart) / 2.0f;
        return new Result(result.toString(), null, new ResultPoint[]{new ResultPoint(left, rowNumber), new ResultPoint(right, rowNumber)}, BarcodeFormat.CODABAR);
    }

    private static int[] findAsteriskPattern(BitArray row) throws NotFoundException {
        int rowOffset;
        int width = row.getSize();
        for (rowOffset = 0; rowOffset < width && !row.get(rowOffset); ++rowOffset) {
        }
        int counterPosition = 0;
        int[] counters = new int[7];
        int patternStart = rowOffset;
        boolean isWhite = false;
        int patternLength = counters.length;
        for (int i = rowOffset; i < width; ++i) {
            boolean pixel = row.get(i);
            if (pixel ^ isWhite) {
                int n = counterPosition;
                counters[n] = counters[n] + 1;
                continue;
            }
            if (counterPosition == patternLength - 1) {
                try {
                    if (CodaBarReader.arrayContains(STARTEND_ENCODING, CodaBarReader.toNarrowWidePattern(counters)) && row.isRange(Math.max(0, patternStart - (i - patternStart) / 2), patternStart, false)) {
                        return new int[]{patternStart, i};
                    }
                }
                catch (IllegalArgumentException re) {
                    // empty catch block
                }
                patternStart += counters[0] + counters[1];
                for (int y = 2; y < patternLength; ++y) {
                    counters[y - 2] = counters[y];
                }
                counters[patternLength - 2] = 0;
                counters[patternLength - 1] = 0;
                --counterPosition;
            } else {
                ++counterPosition;
            }
            counters[counterPosition] = 1;
            isWhite ^= true;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static boolean arrayContains(char[] array, char key) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != key) continue;
                return true;
            }
        }
        return false;
    }

    private static char toNarrowWidePattern(int[] counters) {
        int numCounters = counters.length;
        int maxNarrowCounter = 0;
        int minCounter = Integer.MAX_VALUE;
        for (int i = 0; i < numCounters; ++i) {
            if (counters[i] < minCounter) {
                minCounter = counters[i];
            }
            if (counters[i] <= maxNarrowCounter) continue;
            maxNarrowCounter = counters[i];
        }
        do {
            int i;
            int wideCounters = 0;
            int pattern = 0;
            for (i = 0; i < numCounters; ++i) {
                if (counters[i] <= maxNarrowCounter) continue;
                pattern |= 1 << numCounters - 1 - i;
                ++wideCounters;
            }
            if (wideCounters != 2 && wideCounters != 3) continue;
            for (i = 0; i < CHARACTER_ENCODINGS.length; ++i) {
                if (CHARACTER_ENCODINGS[i] != pattern) continue;
                return ALPHABET[i];
            }
        } while (--maxNarrowCounter > minCounter);
        return '!';
    }
}

