/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.client.result.SMSParsedResult;
import java.util.Hashtable;
import java.util.Vector;

final class SMSMMSResultParser
extends ResultParser {
    private SMSMMSResultParser() {
    }

    public static SMSParsedResult parse(Result result) {
        int comma;
        int queryStart;
        String rawText = result.getText();
        if (rawText == null) {
            return null;
        }
        if (!(rawText.startsWith("sms:") || rawText.startsWith("SMS:") || rawText.startsWith("mms:") || rawText.startsWith("MMS:"))) {
            return null;
        }
        Hashtable nameValuePairs = SMSMMSResultParser.parseNameValuePairs(rawText);
        String subject = null;
        String body = null;
        boolean querySyntax = false;
        if (nameValuePairs != null && !nameValuePairs.isEmpty()) {
            subject = (String)nameValuePairs.get("subject");
            body = (String)nameValuePairs.get("body");
            querySyntax = true;
        }
        String smsURIWithoutQuery = (queryStart = rawText.indexOf(63, 4)) < 0 || !querySyntax ? rawText.substring(4) : rawText.substring(4, queryStart);
        int lastComma = -1;
        Vector numbers = new Vector(1);
        Vector vias = new Vector(1);
        while ((comma = smsURIWithoutQuery.indexOf(44, lastComma + 1)) > lastComma) {
            String numberPart = smsURIWithoutQuery.substring(lastComma + 1, comma);
            SMSMMSResultParser.addNumberVia(numbers, vias, numberPart);
            lastComma = comma;
        }
        SMSMMSResultParser.addNumberVia(numbers, vias, smsURIWithoutQuery.substring(lastComma + 1));
        return new SMSParsedResult(SMSMMSResultParser.toStringArray(numbers), SMSMMSResultParser.toStringArray(vias), subject, body);
    }

    private static void addNumberVia(Vector numbers, Vector vias, String numberPart) {
        int numberEnd = numberPart.indexOf(59);
        if (numberEnd < 0) {
            numbers.addElement(numberPart);
            vias.addElement(null);
        } else {
            numbers.addElement(numberPart.substring(0, numberEnd));
            String maybeVia = numberPart.substring(numberEnd + 1);
            String via = maybeVia.startsWith("via=") ? maybeVia.substring(4) : null;
            vias.addElement(via);
        }
    }
}

