/*
 * Decompiled with CFR 0.152.
 */
package com.zm.app.zxing.camera;

import android.content.Context;
import android.graphics.Point;
import android.hardware.Camera;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;

final class CameraConfigurationManager {
    private static final String TAG = CameraConfigurationManager.class.getSimpleName();
    private static final int TEN_DESIRED_ZOOM = 27;
    private static final int DESIRED_SHARPNESS = 30;
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private final Context context;
    private Point screenResolution;
    private Point cameraResolution;
    private int previewFormat;
    private String previewFormatString;
    private View mView;
    private Comparator<Camera.Size> sizeComparator = new Comparator<Camera.Size>(){

        @Override
        public int compare(Camera.Size lhs, Camera.Size rhs) {
            int firResolution = lhs.width * lhs.height;
            int secResolution = rhs.width * rhs.height;
            if (firResolution == secResolution) {
                return 0;
            }
            if (firResolution < secResolution) {
                return -1;
            }
            return 1;
        }
    };

    CameraConfigurationManager(Context context, View v) {
        this.context = context;
        this.mView = v;
    }

    void initFromCameraParameters(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        this.previewFormat = parameters.getPreviewFormat();
        this.previewFormatString = parameters.get("preview-format");
        int sw = this.getScreenSize(this.context, 0);
        int sh = this.getScreenSize(this.context, 1);
        this.cameraResolution = this.mView == null ? this.getOptimalSize(camera.getParameters().getSupportedPreviewSizes(), sw, sh) : this.getLandOptimalSize(camera.getParameters().getSupportedPreviewSizes(), sw, sh);
        this.screenResolution = new Point(sw, sh - 50);
        Log.d((String)TAG, (String)("Camera resolution: " + this.screenResolution));
    }

    void setDesiredCameraParameters(Camera camera, boolean isLand) {
        Camera.Parameters parameters = camera.getParameters();
        Log.d((String)TAG, (String)("Setting preview size: " + this.cameraResolution));
        parameters.setPreviewSize(this.cameraResolution.x, this.cameraResolution.y);
        this.setFlash(parameters);
        this.setZoom(parameters);
        if (!isLand) {
            this.setDisplayOrientation(camera, 90);
        }
        camera.setParameters(parameters);
    }

    Point getCameraResolution() {
        return this.cameraResolution;
    }

    Point getScreenResolution() {
        return this.screenResolution;
    }

    int getPreviewFormat() {
        return this.previewFormat;
    }

    String getPreviewFormatString() {
        return this.previewFormatString;
    }

    private static Point getCameraResolution(Camera.Parameters parameters, Point screenResolution) {
        String previewSizeValueString = parameters.get("preview-size-values");
        if (previewSizeValueString == null) {
            previewSizeValueString = parameters.get("preview-size-value");
        }
        Point cameraResolution = null;
        if (previewSizeValueString != null) {
            Log.d((String)TAG, (String)("preview-size-values parameter: " + previewSizeValueString));
        }
        if (cameraResolution == null) {
            cameraResolution = new Point(screenResolution.x, screenResolution.y);
        }
        return cameraResolution;
    }

    private static Point findBestPreviewSizeValue(CharSequence previewSizeValueString, Point screenResolution) {
        int bestX = 0;
        int bestY = 0;
        int diff = Integer.MAX_VALUE;
        for (String previewSize : COMMA_PATTERN.split(previewSizeValueString)) {
            int newY;
            int newX;
            int dimPosition = (previewSize = previewSize.trim()).indexOf(120);
            if (dimPosition < 0) {
                Log.w((String)TAG, (String)("Bad preview-size: " + previewSize));
                continue;
            }
            try {
                newX = Integer.parseInt(previewSize.substring(0, dimPosition));
                newY = Integer.parseInt(previewSize.substring(dimPosition + 1));
            }
            catch (NumberFormatException nfe) {
                Log.w((String)TAG, (String)("Bad preview-size: " + previewSize));
                continue;
            }
            int newDiff = Math.abs(newX - screenResolution.x) + Math.abs(newY - screenResolution.y);
            if (newDiff == 0) {
                bestX = newX;
                bestY = newY;
                break;
            }
            if (newDiff >= diff) continue;
            bestX = newX;
            bestY = newY;
            diff = newDiff;
        }
        if (bestX > 0 && bestY > 0) {
            return new Point(bestX, bestY);
        }
        return null;
    }

    private static int findBestMotZoomValue(CharSequence stringValues, int tenDesiredZoom) {
        int tenBestValue = 0;
        for (String stringValue : COMMA_PATTERN.split(stringValues)) {
            double value;
            stringValue = stringValue.trim();
            try {
                value = Double.parseDouble(stringValue);
            }
            catch (NumberFormatException nfe) {
                return tenDesiredZoom;
            }
            int tenValue = (int)(10.0 * value);
            if (!(Math.abs((double)tenDesiredZoom - value) < (double)Math.abs(tenDesiredZoom - tenBestValue))) continue;
            tenBestValue = tenValue;
        }
        return tenBestValue;
    }

    private void setFlash(Camera.Parameters parameters) {
        if (Build.MODEL.contains("Behold II") && Build.VERSION.SDK_INT == 3) {
            parameters.set("flash-value", 1);
        } else {
            parameters.set("flash-value", 2);
        }
        parameters.set("flash-mode", "off");
    }

    private void setZoom(Camera.Parameters parameters) {
        String motZoomStepString;
        String motZoomValuesString;
        String takingPictureZoomMaxString;
        String zoomSupportedString = parameters.get("zoom-supported");
        if (zoomSupportedString != null && !Boolean.parseBoolean(zoomSupportedString)) {
            return;
        }
        int tenDesiredZoom = 27;
        String maxZoomString = parameters.get("max-zoom");
        if (maxZoomString != null) {
            try {
                int tenMaxZoom = (int)(10.0 * Double.parseDouble(maxZoomString));
                if (tenDesiredZoom > tenMaxZoom) {
                    tenDesiredZoom = tenMaxZoom;
                }
            }
            catch (NumberFormatException nfe) {
                Log.w((String)TAG, (String)("Bad max-zoom: " + maxZoomString));
            }
        }
        if ((takingPictureZoomMaxString = parameters.get("taking-picture-zoom-max")) != null) {
            try {
                int tenMaxZoom = Integer.parseInt(takingPictureZoomMaxString);
                if (tenDesiredZoom > tenMaxZoom) {
                    tenDesiredZoom = tenMaxZoom;
                }
            }
            catch (NumberFormatException nfe) {
                Log.w((String)TAG, (String)("Bad taking-picture-zoom-max: " + takingPictureZoomMaxString));
            }
        }
        if ((motZoomValuesString = parameters.get("mot-zoom-values")) != null) {
            tenDesiredZoom = CameraConfigurationManager.findBestMotZoomValue(motZoomValuesString, tenDesiredZoom);
        }
        if ((motZoomStepString = parameters.get("mot-zoom-step")) != null) {
            try {
                double motZoomStep = Double.parseDouble(motZoomStepString.trim());
                int tenZoomStep = (int)(10.0 * motZoomStep);
                if (tenZoomStep > 1) {
                    tenDesiredZoom -= tenDesiredZoom % tenZoomStep;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (maxZoomString != null || motZoomValuesString != null) {
            parameters.set("zoom", String.valueOf((double)tenDesiredZoom / 10.0));
        }
        if (takingPictureZoomMaxString != null) {
            parameters.set("taking-picture-zoom", tenDesiredZoom);
        }
    }

    public static int getDesiredSharpness() {
        return 30;
    }

    protected void setDisplayOrientation(Camera camera, int angle) {
        try {
            Method downPolymorphic = camera.getClass().getMethod("setDisplayOrientation", Integer.TYPE);
            if (downPolymorphic != null) {
                downPolymorphic.invoke((Object)camera, angle);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getScreenSize(Context context, int flag) {
        if (this.mView != null) {
            if (flag == 0) {
                return this.mView.getWidth();
            }
            return this.mView.getHeight();
        }
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics dm = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(dm);
        if (flag == 0) {
            return dm.widthPixels;
        }
        return dm.heightPixels;
    }

    private Point getOptimalSize(List<Camera.Size> sizes, int w, int h) {
        Collections.sort(sizes, this.sizeComparator);
        Camera.Size highestResolution = sizes.get(sizes.size() - 1);
        if (highestResolution.width >= h && highestResolution.height >= w) {
            return new Point(this.getScreenSize(this.context, 1), this.getScreenSize(this.context, 0));
        }
        float rw = highestResolution.width;
        float rh = highestResolution.height;
        float ratio = rw / rh;
        for (int i = sizes.size() - 1; i >= 0; --i) {
            Camera.Size s = sizes.get(i);
            float tw = s.width;
            float th = s.height;
            float tRatio = tw / th;
            if (!((double)Math.abs(tRatio - ratio) < 0.2)) continue;
            return new Point(s.width, s.height);
        }
        return null;
    }

    private Point getLandOptimalSize(List<Camera.Size> sizes, int w, int h) {
        Collections.sort(sizes, this.sizeComparator);
        Camera.Size highestResolution = sizes.get(sizes.size() - 1);
        float rw = highestResolution.width;
        float rh = highestResolution.height;
        float ratio = rw / rh;
        for (int i = sizes.size() - 2; i >= 0; --i) {
            Camera.Size s = sizes.get(i);
            float tw = s.width;
            float th = s.height;
            float tRatio = tw / th;
            if (!((double)Math.abs(tRatio - ratio) < 0.2)) continue;
            return new Point(s.width, s.height);
        }
        return new Point(highestResolution.width, highestResolution.height);
    }
}

