
package com.zm.app.zxing.decoding;
import java.util.Hashtable;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;

import com.zm.app.zxing.IScanProcesse;
import com.zm.app.zxing.R;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import com.zm.app.zxing.camera.CameraManager;
import com.zm.app.zxing.camera.PlanarYUVLuminanceSource;

/**
 * 
 * @author Administrator
 *
 */
final class DecodeHandler extends Handler {

  private static final String TAG = DecodeHandler.class.getSimpleName();

  private final IScanProcesse mScanProcesse;
  private final MultiFormatReader multiFormatReader;

  DecodeHandler(IScanProcesse scanProcesse, Hashtable<DecodeHintType, Object> hints) {
    multiFormatReader = new MultiFormatReader();
    multiFormatReader.setHints(hints);
    this.mScanProcesse = scanProcesse;
  }

  @Override
  public void handleMessage(Message message) {
	  if(message.what == R.id.decode){
		  decode((byte[]) message.obj, message.arg1, message.arg2);
	  }else if(message.what == R.id.quit){
		  Looper.myLooper().quit();
	  }
  }

  
  private void decode(byte[] data, int width, int height) {
    long start = System.currentTimeMillis();
    Result rawResult = null;
    
    //modify here
    byte[] rotatedData = new byte[width*height];
//    byte[] rotatedData = new byte[data.length];
    
    for (int y = 0; y < height; y++) {
        for (int x = 0; x < width; x++)
            rotatedData[x * height + height - y - 1] = data[x + y * width];
    }
    int tmp = width; // Here we are swapping, that's the difference to #11
    width = height;
    height = tmp;
    
    PlanarYUVLuminanceSource source = CameraManager.get().buildLuminanceSource(rotatedData, width, height);
    BinaryBitmap bitmap = new BinaryBitmap(new HybridBinarizer(source));
    try {
      rawResult = multiFormatReader.decodeWithState(bitmap);
    } catch (ReaderException re) {
      // continue
    } finally {
      multiFormatReader.reset();
    }

    if (rawResult != null) {
      long end = System.currentTimeMillis();
      Log.d(TAG, "Found barcode (" + (end - start) + " ms):\n" + rawResult.toString());
      Message message = Message.obtain(mScanProcesse.getHandler(), R.id.decode_succeeded, rawResult);
      Bundle bundle = new Bundle();
      bundle.putParcelable(DecodeThread.BARCODE_BITMAP, source.renderCroppedGreyscaleBitmap());
      message.setData(bundle);
      //Log.d(TAG, "Sending decode succeeded message...");
      message.sendToTarget();
    } else {
      Message message = Message.obtain(mScanProcesse.getHandler(), R.id.decode_failed);
      message.sendToTarget();
    }
  }

}
