package com.boanda.android.push;

import com.boanda.android.push.receive.PushBody;
import com.szboanda.android.platform.db.DbHelper;

import java.util.List;

/**
 * Created by Administrator on 2017/6/19.
 */

public class PushDataCenter {

    public static void save(PushBody pushBody){
        try{
            pushBody.setAliasId(PushProxy.getAlias());
            DbHelper.getDao().save(pushBody);
        }catch(Exception e){
            e.printStackTrace();
        }
    }

    public static void read(String msgId){
        try{
            PushBody body = DbHelper.getDao().findById(PushBody.class, msgId);
            if(body != null){
                body.setRead(true);
                DbHelper.getDao().saveOrUpdate(body);
            }
        }catch(Exception e){
            e.printStackTrace();
        }
    }

    public static List<PushBody> queryUnreadMessage(){
        List<PushBody> unread = null;
        try{
            unread = DbHelper.getDao().selector(PushBody.class)
                    .where("read_status", "=", "0")
                    .and("alias_id", "=", PushProxy.getAlias())
                    .findAll();
        }catch(Exception e){
            e.printStackTrace();
        }
        return unread;
    }

    public static void deleteMessage(String msgId){
        try{
            DbHelper.getDao().deleteById(PushBody.class, msgId);
        }catch(Exception e){
            e.printStackTrace();
        }
    }

}
