package com.boanda.android.push.receive;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

import org.json.JSONObject;
import org.xutils.db.annotation.Column;
import org.xutils.db.annotation.Table;

/**
 * Created by Administrator on 2017/6/15.
 */
@Table(name = "T_PUSH_MESSAGE")
public class PushBody implements Parcelable{

    public static final String KEY_TITLE = "title";

    public static final String KEY_MESSAGE= "message";

    public static final String KEY_ACTION = "action";

    public static final String KEY_CATEGORY = "category";

    public static final String KEY_TIME = "time";

    public static final String KEY_EXTRA = "action_extra";

    public static final Parcelable.Creator CREATOR = new Parcelable.Creator<PushBody>(){

        @Override
        public PushBody createFromParcel(Parcel source) {
            return new PushBody(source);
        }

        @Override
        public PushBody[] newArray(int size) {
            return new PushBody[size];
        }
    };

    public PushBody(){}

    private PushBody(Parcel source){
        msgId = source.readString();
        title = source.readString();
        message = source.readString();
        action = source.readString();
        category = source.readString();
        extra = source.readString().trim();
        timeInMill = source.readLong();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(msgId);
        dest.writeString(title);
        dest.writeString(message);
        dest.writeString(action);
        dest.writeString(category);
        dest.writeString(extra == null ? " " : extra.toString());
        dest.writeLong(timeInMill);
    }

    @Column(name = "_id", isId = true)
    private String msgId;

    @Column(name = "title")
    private String title;

    @Column(name = "message")
    private String message;

    @Column(name = "category")
    private String category;

    @Column(name = "action")
    private String action;

    @Column(name = "read_status")
    private boolean readStatus;

    @Column(name = "time")
    private long timeInMill;

    @Column(name = "action_extra")
    private String extra;

    public String getMsgId() {
        return msgId;
    }

    public PushBody setMsgId(String msgId) {
        this.msgId = msgId;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public PushBody setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getMessage() {
        return message;
    }

    public PushBody setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getAction() {
        return action;
    }

    public PushBody setAction(String action) {
        this.action = action;
        return this;
    }

    public String getCategory() {
        return category;
    }

    public PushBody setCategory(String category) {
        this.category = category;
        return this;
    }

    public void setRead(boolean read){
        readStatus = read;
    }

    public boolean isRead(){
        return readStatus;
    }

    public long getTime() {
        return timeInMill;
    }

    public PushBody setTime(long timeInMill) {
        this.timeInMill = timeInMill;
        return this;
    }

    public String getExtra() {
        return extra;
    }

    public PushBody setExtra(String extra) {
        this.extra = extra;
        return this;
    }

    public JSONObject getExtraObject(){
        JSONObject object = null;
        try{
            if(!TextUtils.isEmpty(extra)){
                object = new JSONObject(extra);
            }
        }catch(Exception e){
            e.printStackTrace();
        }
        return object;
    }

}
