/*
 * Decompiled with CFR 0.152.
 */
package com.boanda.android.push;

import android.content.Context;
import com.boanda.android.push.DefaultSetCallback;
import com.boanda.android.push.IPushExecutor;
import com.boanda.android.push.ISetCallback;
import com.boanda.android.push.receive.IMessageDispatcher;
import com.boanda.android.push.receive.PushBody;
import com.szboanda.android.platform.db.DbHelper;
import java.util.HashSet;

public class PushProxy {
    private static Context mContext;
    private static IPushExecutor mPushExecutor;
    private static IMessageDispatcher mMessageDispatcher;

    public static void init(Context context, Class<?> executorCls) {
        mContext = context;
        try {
            Object instance = executorCls.newInstance();
            if (instance instanceof IPushExecutor) {
                mPushExecutor = (IPushExecutor)instance;
                mPushExecutor.init(context);
            }
            DbHelper.getDao().createTableIfNotExist(PushBody.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setAlias(String alias) {
        PushProxy.setAlias(alias, new DefaultSetCallback());
    }

    public static void setAlias(String alias, ISetCallback callback) {
        if (mPushExecutor != null) {
            mPushExecutor.setAliasAndTags(alias, new HashSet<String>(), callback);
        }
    }

    public static Context getContext() {
        return mContext;
    }

    public static void registerDispatcher(IMessageDispatcher dispatcher) {
        mMessageDispatcher = dispatcher;
    }

    public static IMessageDispatcher getDispatcher() {
        return mMessageDispatcher;
    }
}

