package com.boanda.android.push;

import android.content.Context;
import android.os.Handler;

import java.util.Set;

import cn.jpush.android.api.JPushInterface;
import cn.jpush.android.api.TagAliasCallback;

/**
 * Created by Administrator on 2017/6/15.
 */

public class JPushExecutor implements IPushExecutor {

    private final int RESULT_CODE_SUCCESS = 0;

    private final int RESULT_CODE_TIMEOUT = 6002;

    @Override
    public void init(Context context) {
        JPushInterface.init(context);
    }

    @Override
    public void setAliasAndTags(String alias, Set<String> tags, ISetCallback callback) {
        JPushInterface.setAliasAndTags(PushProxy.getContext(), alias, tags, new JPushSetCallback(callback));
    }

    class JPushSetCallback implements TagAliasCallback{

        ISetCallback mCallback;

        public JPushSetCallback(ISetCallback callback){
            mCallback = callback;
        }

        @Override
        public void gotResult(int code, String alias, Set<String> set) {
            switch (code){
                case RESULT_CODE_SUCCESS:
                    if(mCallback != null) {
                        mCallback.onSuccess(alias);
                    }
                    break;
                case RESULT_CODE_TIMEOUT:
                    if(mCallback != null) {
                        mCallback.onTimeout(alias);
                    }
                    break;
                default:
                    if(mCallback != null) {
                        mCallback.onFailuer(code, "检测极光推送配置");
                    }
                    break;
            }
        }
    }


}
