/*
 * Decompiled with CFR 0.152.
 */
package com.boanda.android.permission.plus;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.PermissionInfo;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import com.boanda.android.permission.plus.IDeniedTipBuilder;
import java.util.ArrayList;

public class PermissionPlus {
    private static final int PERMISSION_REQUEST_CODE_SDCARD = 31;
    private static int EXTEND_HANDLER_ARRAY_ID = -1;
    private static IDeniedTipBuilder DENIED_TIP_BUILDER = null;

    public static void setExtendHandlerArrayId(int extendHandlerArrayResId) {
        EXTEND_HANDLER_ARRAY_ID = extendHandlerArrayResId;
    }

    public static int getExtendHandlerArrayId() {
        return EXTEND_HANDLER_ARRAY_ID;
    }

    public static void setDeniedTipBuilder(IDeniedTipBuilder tipBuilder) {
        DENIED_TIP_BUILDER = tipBuilder;
    }

    public static IDeniedTipBuilder getDeniedTipBuilder() {
        return DENIED_TIP_BUILDER;
    }

    public static boolean shouldCheck() {
        return Build.VERSION.SDK_INT > 22;
    }

    public static void requireAllTogethe(Activity activity) {
        String[] dangerousPermissions;
        if (PermissionPlus.shouldCheck() && (dangerousPermissions = PermissionPlus.getDangerousPermissions((Context)activity)) != null) {
            ArrayList<String> needChecks = new ArrayList<String>();
            for (String dp : dangerousPermissions) {
                if (PermissionPlus.checkPermission((Context)activity, dp)) continue;
                needChecks.add(dp);
            }
            if (needChecks.size() > 0) {
                ActivityCompat.requestPermissions((Activity)activity, (String[])needChecks.toArray(new String[needChecks.size()]), (int)31);
            }
        }
    }

    public static boolean checkPermission(Context context, String permission2) {
        if (PermissionPlus.shouldCheck()) {
            return 0 == ContextCompat.checkSelfPermission((Context)context, (String)permission2);
        }
        return true;
    }

    public static void requireSdcardReadAndWrite(Activity activity) {
        if (PermissionPlus.shouldCheck()) {
            ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"}, (int)31);
        }
    }

    public static boolean checkSdcardReadable(Context context) {
        return PermissionPlus.checkPermission(context, "android.permission.READ_EXTERNAL_STORAGE");
    }

    public static boolean checkSdcardWriteable(Context context) {
        return PermissionPlus.checkPermission(context, "android.permission.READ_EXTERNAL_STORAGE");
    }

    @Nullable
    public static String[] getDangerousPermissions(Context context) {
        PackageManager pm = context.getPackageManager();
        ArrayList<String> result = null;
        try {
            String[] declarePermissions = pm.getPackageInfo((String)context.getPackageName(), (int)4096).requestedPermissions;
            if (declarePermissions != null && declarePermissions.length > 0) {
                result = new ArrayList<String>();
                for (String p : declarePermissions) {
                    try {
                        PermissionInfo pi = pm.getPermissionInfo(p, 0);
                        if (pi.protectionLevel != 1) continue;
                        result.add(p);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result != null) {
            return result.toArray(new String[result.size()]);
        }
        return null;
    }

    public static String getPermissionDesc(Context context, String permission2) {
        String desc = "";
        PackageManager pm = context.getPackageManager();
        try {
            PermissionInfo pi = pm.getPermissionInfo(permission2, 0);
            desc = context.getString(pi.descriptionRes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return desc;
    }
}

