/*
 * Decompiled with CFR 0.152.
 */
package com.boanda.android.permission.plus;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.util.SparseArray;
import com.boanda.android.permission.plus.IPermissionHandler;
import com.boanda.android.permission.plus.PermissionPlus;
import com.boanda.android.permission.plus.PermissionRequestCode;

public class DefaultPermissionHandler
implements IPermissionHandler {
    private SparseArray<IPermissionHandler> mConfig = null;
    private Context mContext;
    private boolean mAllGranted = true;

    public DefaultPermissionHandler(Context context) {
        this.mContext = context;
        this.mConfig = new SparseArray();
        int extendArrayResId = PermissionPlus.getExtendHandlerArrayId();
        if (extendArrayResId != -1) {
            String[] clsArray;
            for (String clsName : clsArray = context.getResources().getStringArray(extendArrayResId)) {
                PermissionRequestCode pt;
                Class<?> cls = DefaultPermissionHandler.loadClass(clsName);
                if (cls == null || (pt = cls.getAnnotation(PermissionRequestCode.class)) == null) continue;
                this.mConfig.put(pt.code(), (Object)((IPermissionHandler)DefaultPermissionHandler.loadInstance(cls)));
            }
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        IPermissionHandler handler;
        for (int g : grantResults) {
            if (-1 != g) continue;
            this.mAllGranted = false;
            break;
        }
        if ((handler = (IPermissionHandler)this.mConfig.get(requestCode)) != null) {
            handler.onRequestPermissionsResult(requestCode, permissions, grantResults);
        } else {
            int i = 0;
            for (String p : permissions) {
                if (-1 == grantResults[i]) {
                    String desc = PermissionPlus.getPermissionDesc(this.mContext, permissions[i]);
                    String tip = "\u60a8\u62d2\u7edd\u4e86" + desc + "\u6743\u9650\uff0c\u53ef\u80fd\u5bfc\u81f4\u90e8\u5206\u4e0d\u80fd\u6b63\u5e38\u4f7f\u7528\uff0c" + "\u5982\u9700\u6253\u5f00\u6743\u9650\uff0c\u8bf7\u5230[\u8bbe\u7f6e]>[\u6743\u9650\u7ba1\u7406]\u9875\u9762\u6253\u5f00\u76f8\u5e94\u6743\u9650";
                    Object tipDialog = null;
                    tipDialog = PermissionPlus.getDeniedTipBuilder() != null ? PermissionPlus.getDeniedTipBuilder().build(tip) : new AlertDialog.Builder(this.mContext).setTitle((CharSequence)"\u6e29\u99a8\u63d0\u793a").setMessage((CharSequence)tip).setNegativeButton((CharSequence)"\u5173\u95ed", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        }
                    }).create();
                    tipDialog.show();
                }
                ++i;
            }
        }
    }

    public boolean isAllGranted() {
        return this.mAllGranted;
    }

    public static final Class<?> loadClass(String className) {
        Class<?> c = null;
        if (!TextUtils.isEmpty((CharSequence)className)) {
            try {
                c = Class.forName(className);
            }
            catch (Exception e) {
                e.printStackTrace();
                c = null;
            }
        }
        return c;
    }

    public static final <E> E loadInstance(String className) {
        return DefaultPermissionHandler.loadInstance(DefaultPermissionHandler.loadClass(className));
    }

    public static <E> E loadInstance(Class<?> cls) {
        Object c = null;
        if (cls != null) {
            try {
                Object instance = cls.newInstance();
                c = instance;
            }
            catch (Exception e) {
                e.printStackTrace();
                c = null;
            }
        }
        return c;
    }
}

