package com.boanda.android.permission.plus;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.PermissionInfo;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Administrator on 2016/11/30.
 */

public class PermissionPlus {

    private final static int PERMISSION_REQUEST_CODE_SDCARD = 0x01f;

    private static int EXTEND_HANDLER_ARRAY_ID = -1;

    private static IDeniedTipBuilder DENIED_TIP_BUILDER = null;

    public static void setExtendHandlerArrayId(int extendHandlerArrayResId){
        EXTEND_HANDLER_ARRAY_ID = extendHandlerArrayResId;
    }

    public static int getExtendHandlerArrayId(){
        return EXTEND_HANDLER_ARRAY_ID;
    }

    public static void setDeniedTipBuilder(IDeniedTipBuilder tipBuilder){
        DENIED_TIP_BUILDER = tipBuilder;
    }

    public static IDeniedTipBuilder getDeniedTipBuilder(){
        return DENIED_TIP_BUILDER;
    }

    public static boolean shouldCheck(){
        return Build.VERSION.SDK_INT > Build.VERSION_CODES.LOLLIPOP_MR1;
    }

    public static void requireAllTogethe(Activity activity){
        if(shouldCheck()) {
            String[] dangerousPermissions = getDangerousPermissions(activity);
            if(dangerousPermissions != null){
                List<String> needChecks = new ArrayList<>();
                for(String dp : dangerousPermissions){
                    if(!checkPermission(activity, dp)){
                        needChecks.add(dp);
                    }
                }
                if(needChecks.size() > 0) {
                    ActivityCompat.requestPermissions(activity,
                        needChecks.toArray(new String[needChecks.size()]),
                        PERMISSION_REQUEST_CODE_SDCARD);
                }
            }
        }
    }

    public static boolean checkPermission(Context context, String permission){
        if(shouldCheck()){
            return PackageManager.PERMISSION_GRANTED == ContextCompat
                .checkSelfPermission(context, permission);
        }else{
            return true;
        }
    }

    public static void requireSdcardReadAndWrite(Activity activity){
        if(shouldCheck()){
            ActivityCompat.requestPermissions(activity
                , new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE,
                Manifest.permission.READ_EXTERNAL_STORAGE}
                , PERMISSION_REQUEST_CODE_SDCARD);
        }
    }

    public static boolean checkSdcardReadable(Context context){
        return checkPermission(context, Manifest.permission.READ_EXTERNAL_STORAGE);
    }

    public static boolean checkSdcardWriteable(Context context){
        return checkPermission(context, Manifest.permission.READ_EXTERNAL_STORAGE);
    }

    @Nullable
    public static String[] getDangerousPermissions(Context context){
        PackageManager pm = context.getPackageManager();
        List<String> result = null;
        try{
            String[] declarePermissions = pm.getPackageInfo(
                context.getPackageName(), PackageManager.GET_PERMISSIONS).requestedPermissions;
            if(declarePermissions != null && declarePermissions.length > 0){
                result = new ArrayList<>();
                for(String p : declarePermissions){
                    try{
                        PermissionInfo pi = pm.getPermissionInfo(p, 0);
                        if(pi.protectionLevel == PermissionInfo.PROTECTION_DANGEROUS){
                            result.add(p);
                        }
                    }catch(Exception e){
                        e.printStackTrace();
                    }
                }
            }
        }catch(Exception e){
            e.printStackTrace();
        }
        if (result != null) {
            return result.toArray(new String[result.size()]);
        }else{
            return null;
        }
    }

    public static String getPermissionDesc(Context context, String permission){
        String desc = "";
        PackageManager pm = context.getPackageManager();
        try{
            PermissionInfo pi = pm.getPermissionInfo(permission, 0);
            desc = context.getString(pi.descriptionRes);
        }catch(Exception e){
            e.printStackTrace();
        }
        return desc;
    }

}
