package com.boanda.android.permission.plus;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.SparseArray;

/**
 *默认权限回调处理实现
 */
public class DefaultPermissionHandler implements IPermissionHandler{

    private SparseArray<IPermissionHandler> mConfig = null;

    private Context mContext;

    private boolean mAllGranted = true;

    public DefaultPermissionHandler(Context context){
        mContext = context;
        mConfig = new SparseArray<IPermissionHandler>();
        int extendArrayResId = PermissionPlus.getExtendHandlerArrayId();
        if (extendArrayResId != -1) {
            String[] clsArray = context.getResources().getStringArray(extendArrayResId);
            for (String clsName : clsArray){
                Class<?> cls = loadClass(clsName);
                if(cls != null){
                    PermissionRequestCode pt = cls.getAnnotation(PermissionRequestCode.class);
                    if(pt != null){
                        mConfig.put(pt.code(), (IPermissionHandler) loadInstance(cls));
                    }
                }
            }
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        for(int g : grantResults){
            if(PackageManager.PERMISSION_DENIED == g){
                mAllGranted = false;
                break;
            }
        }
        IPermissionHandler handler = mConfig.get(requestCode);
        if (handler != null){
            handler.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }else{
            int i = 0;
            for(String p : permissions){
                if(PackageManager.PERMISSION_DENIED == grantResults[i]){
                    String desc = PermissionPlus.getPermissionDesc(mContext, permissions[i]);
                    String tip = "您拒绝了" + desc + "权限，可能导致部分不能正常使用，" +
                        "如需打开权限，请到[设置]>[权限管理]页面打开相应权限";
                    Dialog tipDialog = null;
                    if(PermissionPlus.getDeniedTipBuilder() != null){
                        tipDialog = PermissionPlus.getDeniedTipBuilder().build(tip);
                    }else{
                        tipDialog = new AlertDialog.Builder(mContext)
                            .setTitle("温馨提示")
                            .setMessage(tip)
                            .setNegativeButton("关闭", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    dialog.dismiss();
                                }
                            })
                            .create();
                    }
                    tipDialog.show();
                }
                i++;
            }
        }
    }

    public boolean isAllGranted(){
        return mAllGranted;
    }

    public static final Class<?> loadClass(String className) {
        Class<?> c = null;
        if(!TextUtils.isEmpty(className)){
            try {
                c = Class.forName(className);
            } catch (Exception e) {
                e.printStackTrace();
                c = null;
            }
        }
        return c;
    }

    public static final <E> E loadInstance(String className){
        return loadInstance(loadClass(className));
    }

    @SuppressWarnings("unchecked")
    public static <E> E loadInstance(Class<?> cls) {
        E c = null;
        if(cls != null){
            try {
                Object instance = cls.newInstance();
                c = (E)instance;
            } catch (Exception e) {
                e.printStackTrace();
                c = null;
            }
        }
        return c;
    }
}
