/*
 * Decompiled with CFR 0.152.
 */
package com.boanda.android.sync;

import android.content.Context;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.widget.Toast;
import com.boanda.android.sync.DataSyncManager;
import com.boanda.android.sync.DataSyncParams;
import com.boanda.android.sync.SyncAll;
import com.boanda.android.sync.SyncConfig;
import com.boanda.android.sync.SyncServiceEnum;
import com.boanda.android.sync.SyncSubmitItem;
import com.szboanda.android.platform.db.DbHelper;
import com.szboanda.android.platform.db.SQLiteDao;
import com.szboanda.android.platform.http.HttpTask;
import com.szboanda.android.platform.http.ParamsWrapper;
import com.szboanda.android.platform.http.ResponseProcessor;
import com.szboanda.android.platform.util.BeanUtil;
import com.szboanda.android.platform.util.FileUtils;
import com.szboanda.android.platform.util.StringUtils;
import io.reactivex.Flowable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xutils.db.Selector;
import org.xutils.db.sqlite.WhereBuilder;
import org.xutils.db.table.TableEntity;

public class SyncSubmitManager {
    public static final String RELATIVE_DIR = "/tempSubmitData";
    public static final String TABLE_DATA_FILE_SUFFIX = ".tabd";
    private static final String CONTENT_TYPE_FILE = "file";
    private static final String IDENTIFY_SERVICE_PATH = "@path:";
    private static Object mLock = new Object();
    private static SyncSubmitManager INSTANCE;
    private Context context;
    private Handler handler;

    private SyncSubmitManager() {
        try {
            DbHelper.createTableIfNotExist(SyncSubmitItem.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SyncSubmitManager getInstance() {
        if (INSTANCE == null) {
            Object object = mLock;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new SyncSubmitManager();
                }
            }
        }
        return INSTANCE;
    }

    public <E> void appendSubmitItem(List<E> entitys) {
        if (entitys != null) {
            for (E e : entitys) {
                this.appendSubmitItem(e);
            }
        }
    }

    public <E> boolean appendSubmitItem(E entity) {
        SyncSubmitItem item = new SyncSubmitItem();
        try {
            Object idValue = DbHelper.getDao().getTable(entity.getClass()).getId().getColumnValue(entity);
            item.setTable(entity.getClass().getName());
            item.setPkValue(idValue + "");
            SyncConfig config = DataSyncManager.getInstance().getParamConfig();
            String userId = config.getUserId();
            item.setCjr(userId);
            item.setXgr(userId);
            item.setCjsj(new Date());
            item.setXgsj(new Date());
            item.setOrgid(config.getOrgid());
            item.setSubmited(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.addSyncItemToQueue(item);
    }

    public void appendSubmitFile(List<File> files) {
        if (files != null) {
            for (File f : files) {
                this.appendSubmitFile(f);
            }
        }
    }

    public boolean appendSubmitFile(File file) {
        return this.appendSubmitFile(file, null);
    }

    public boolean appendSubmitFile(String filePath) {
        return this.appendSubmitFile(new File(filePath), null);
    }

    public boolean appendSubmitFile(String filePath, String servicePath) {
        return this.appendSubmitFile(new File(filePath), servicePath);
    }

    public boolean appendSubmitFile(File file, String servicePath) {
        SyncSubmitItem item = new SyncSubmitItem();
        item.setTable(CONTENT_TYPE_FILE);
        if (TextUtils.isEmpty((CharSequence)servicePath)) {
            item.setPkValue(file.getAbsolutePath());
        } else {
            item.setPkValue(file.getAbsolutePath() + IDENTIFY_SERVICE_PATH + servicePath);
        }
        SyncConfig config = DataSyncManager.getInstance().getParamConfig();
        String userId = config.getUserId();
        item.setCjr(userId);
        item.setXgr(userId);
        item.setCjsj(new Date());
        item.setXgsj(new Date());
        item.setOrgid(config.getOrgid());
        item.setSubmited(false);
        return this.addSyncItemToQueue(item);
    }

    private boolean addSyncItemToQueue(SyncSubmitItem item) {
        boolean isSuccess = false;
        try {
            SyncSubmitItem findItem = this.isItemExist(item);
            if (findItem == null) {
                DbHelper.getDao().save((Object)item);
            } else {
                item.setId(findItem.getId());
                DbHelper.getDao().update((Object)item, new String[]{"tab_name", "pk_value", "submited", "xgr", "xgsj"});
            }
            isSuccess = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isSuccess;
    }

    public void submitSyncData(Class<?> tableCls) {
        if (tableCls == null) {
            this.submitSyncData(SyncAll.class, null);
        } else {
            this.submitSyncData(tableCls, null);
        }
    }

    private void submitSyncData(Class<?> tableCls, final String filePath) {
        SyncConfig config = DataSyncManager.getInstance().getParamConfig();
        if (!TextUtils.isEmpty((CharSequence)config.getUserId())) {
            Flowable.just(tableCls).subscribeOn(Schedulers.io()).map(new Function<Class<?>, List<String>>(){

                public List<String> apply(Class<?> cls) throws Exception {
                    return SyncSubmitManager.this.createTempSubmitFile(cls);
                }
            }).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<List<String>>(){

                public void accept(List<String> paths) throws Exception {
                    SyncSubmitManager.this.submitSyncDataFile(paths, filePath);
                }
            });
        }
    }

    public void submitSyncData() {
        this.submitSyncData(null);
    }

    public void submitSyncFile(String filePath) {
        this.submitSyncData(null, filePath);
    }

    private File getSubmitDataTempDir() {
        String dirPath = DataSyncManager.getInstance().getCachePath() + RELATIVE_DIR;
        return new File(dirPath);
    }

    private List<String> createTempSubmitFile(Class<?> indentifyTableCls) {
        String sql;
        File dir = this.getSubmitDataTempDir();
        if (dir.exists()) {
            File[] childFiles = dir.listFiles();
            if (childFiles != null) {
                for (File cf : childFiles) {
                    cf.delete();
                }
            }
        } else {
            dir.mkdirs();
        }
        if (indentifyTableCls != null && !indentifyTableCls.equals(SyncAll.class)) {
            String tableName = indentifyTableCls.getName();
            sql = "SELECT TAB_NAME FROM T_SUBMIT_ITEMS WHERE TAB_NAME = '" + tableName + "' AND SUBMITED <> 1  AND TAB_NAME <> 'file' GROUP BY TAB_NAME";
        } else {
            sql = "SELECT TAB_NAME FROM T_SUBMIT_ITEMS WHERE SUBMITED <> 1  AND TAB_NAME <> 'file' GROUP BY TAB_NAME";
        }
        ArrayList<String> submitTableFiles = new ArrayList<String>();
        try {
            SQLiteDao dao = DbHelper.getDao();
            JSONArray tables = dao.getListValue(sql);
            if (tables != null) {
                for (int i = 0; i < tables.length(); ++i) {
                    JSONObject item = tables.optJSONObject(i);
                    String tableClsStr = item.optString("TAB_NAME");
                    Class tableCls = BeanUtil.loadClass((String)tableClsStr);
                    TableEntity table = dao.getTable(tableCls);
                    String tn = table.getName();
                    String idCol = table.getId().getName();
                    String dataSql = "SELECT MT.* FROM " + tn + " MT INNER JOIN T_SUBMIT_ITEMS ST ON MT." + idCol + " = ST.pk_value";
                    JSONArray submitDataItems = dao.getListValue(dataSql);
                    if (submitDataItems == null) continue;
                    String submitFileName = tn + TABLE_DATA_FILE_SUFFIX;
                    boolean success = FileUtils.createFileByContent((String)dir.getAbsolutePath(), (String)submitFileName, (String)submitDataItems.toString());
                    if (!success) continue;
                    submitTableFiles.add(dir.getAbsolutePath() + File.separator + submitFileName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return submitTableFiles;
    }

    private void submitSyncDataFile(List<String> tableDataFiles, String filePath) {
        List<String> syncFiles;
        boolean hasSyncData = false;
        DataSyncParams params = new DataSyncParams();
        params.setMultipart(true);
        params.addQueryStringParameter("service", SyncServiceEnum.SUBMIT_TABLE_FILE.name());
        if (tableDataFiles != null) {
            hasSyncData = tableDataFiles.size() > 0;
            for (String path : tableDataFiles) {
                String fn = StringUtils.parseFileName((String)path);
                params.addBodyParameter(fn, new File(path));
            }
        }
        if ((syncFiles = this.findSyncFiles(filePath)) != null) {
            hasSyncData = hasSyncData || syncFiles.size() > 0;
            String sdCardPath = Environment.getExternalStorageDirectory().getAbsolutePath();
            for (String path : syncFiles) {
                File f = new File(path.split(IDENTIFY_SERVICE_PATH)[0]);
                if (!f.exists()) continue;
                params.addBodyParameter(path.replace(sdCardPath, ""), f);
            }
        }
        if (hasSyncData) {
            HttpTask submitTask = this.context != null ? new HttpTask(this.context, "\u6b63\u5728\u540c\u6b65\u6570\u636e") : new HttpTask();
            ResponseProcessor<JSONObject> processor = new ResponseProcessor<JSONObject>(){

                public void onSuccessTyped(JSONObject result) {
                    SyncSubmitManager.this.deleteTempSubmitFile();
                    if (result != null) {
                        boolean isSuccess = result.optBoolean("isSuccess");
                        if (SyncSubmitManager.this.handler != null) {
                            Message msg = new Message();
                            msg.what = 0;
                            msg.arg1 = isSuccess ? 0 : 1;
                            SyncSubmitManager.this.handler.sendMessage(msg);
                        }
                        if (isSuccess) {
                            String submitTables = result.optString("tables");
                            try {
                                String successedFiles;
                                Map tableClsMap = SyncSubmitManager.this.findTableClassMap();
                                if (!TextUtils.isEmpty((CharSequence)submitTables) && tableClsMap != null) {
                                    String[] tables;
                                    for (String t : tables = submitTables.split(";")) {
                                        String clsName = (String)tableClsMap.get(t);
                                        if (TextUtils.isEmpty((CharSequence)clsName)) continue;
                                        WhereBuilder wb = WhereBuilder.b((String)"tab_name", (String)"=", (Object)clsName);
                                        DbHelper.getDao().delete(SyncSubmitItem.class, wb);
                                    }
                                }
                                if (!TextUtils.isEmpty((CharSequence)(successedFiles = result.optString("files")))) {
                                    String[] paths;
                                    for (String sp : paths = successedFiles.split(",")) {
                                        for (String lp : syncFiles) {
                                            if (!lp.endsWith(sp) && !lp.equals(sp)) continue;
                                            WhereBuilder wb = WhereBuilder.b((String)"pk_value", (String)"=", (Object)lp);
                                            DbHelper.getDao().delete(SyncSubmitItem.class, wb);
                                            System.out.println("delete:" + lp);
                                        }
                                    }
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }

                public void onError(Throwable ex, boolean isOnCallback) {
                    if (SyncSubmitManager.this.context != null) {
                        Toast.makeText((Context)SyncSubmitManager.this.context, (CharSequence)"\u63d0\u4ea4\u5931\u8d25", (int)0).show();
                    }
                    if (SyncSubmitManager.this.handler != null) {
                        Message msg = new Message();
                        msg.what = 0;
                        msg.arg1 = 1;
                        SyncSubmitManager.this.handler.sendMessage(msg);
                    }
                }
            };
            submitTask.executePost((ParamsWrapper)params, this.context != null, (ResponseProcessor)processor);
        }
    }

    private Map<String, String> findTableClassMap() {
        HashMap<String, String> tableClassMap = null;
        try {
            String tableName = DbHelper.getDao().getTable(SyncSubmitItem.class).getName();
            String sql = "SELECT TAB_NAME FROM " + tableName + " WHERE SUBMITED <> 1  AND TAB_NAME <> 'file' GROUP BY TAB_NAME";
            SQLiteDao dao = DbHelper.getDao();
            JSONArray tables = dao.getListValue(sql);
            if (tables != null) {
                tableClassMap = new HashMap<String, String>();
                for (int i = 0; i < tables.length(); ++i) {
                    JSONObject tb = tables.optJSONObject(i);
                    String clsName = tb.optString("TAB_NAME");
                    Class cls = BeanUtil.loadClass((String)clsName);
                    String tn = dao.getTable(cls).getName();
                    tableClassMap.put(tn, clsName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableClassMap;
    }

    private List<String> findSyncFiles(String filePath) {
        ArrayList<String> syncFiles = null;
        try {
            List items;
            Selector s = DbHelper.getDao().selector(SyncSubmitItem.class);
            s.where("tab_name", "=", (Object)CONTENT_TYPE_FILE);
            s.and("submited", "=", (Object)false);
            if (!TextUtils.isEmpty((CharSequence)filePath)) {
                s.and("pk_value", "like", (Object)(filePath + "%"));
            }
            if ((items = s.findAll()) != null) {
                syncFiles = new ArrayList<String>();
                for (SyncSubmitItem si : items) {
                    String path = (String)si.getPkValue();
                    File f = new File(path.split(IDENTIFY_SERVICE_PATH)[0]);
                    if (!f.exists()) continue;
                    syncFiles.add(path);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return syncFiles;
    }

    private void deleteTempSubmitFile() {
        File dir = this.getSubmitDataTempDir();
        File[] childFiles = dir.listFiles();
        if (childFiles != null) {
            for (File cf : childFiles) {
                cf.delete();
            }
        }
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    private SyncSubmitItem isItemExist(SyncSubmitItem item) {
        SyncSubmitItem findItem = null;
        try {
            findItem = (SyncSubmitItem)DbHelper.getDao().selector(SyncSubmitItem.class).where("tab_name", "=", (Object)item.getTable()).and("pk_value", "=", item.getPkValue()).findFirst();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return findItem;
    }
}

