/*
 * Decompiled with CFR 0.152.
 */
package com.boanda.android.sync;

import android.text.TextUtils;
import com.boanda.android.sync.DataSyncManager;
import com.boanda.android.sync.DataSyncResponse;
import com.boanda.android.sync.HybridSyncParser;
import com.boanda.android.sync.SyncJsonParser;
import com.boanda.android.sync.SyncXmlParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.xutils.http.app.InputStreamResponseParser;
import org.xutils.http.request.UriRequest;

public class SyncResponseProcessor
extends InputStreamResponseParser {
    private static final String DEPART_FILE_SINGLES = "########";
    private String syncFilePath = "/response/";
    private List<File> mSyncDataFiles = null;
    private boolean isJsonSupport = false;

    public Object parse(Type type, Class<?> aClass, InputStream inputStream) throws Throwable {
        this.process(inputStream);
        return new DataSyncResponse(this);
    }

    public void checkResponse(UriRequest uriRequest) throws Throwable {
    }

    public void process(InputStream inputStream) {
        this.saveSyncDataFile(inputStream);
        this.parseFileAndSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSyncDataFile(InputStream is) {
        this.mSyncDataFiles = new ArrayList<File>();
        if (is != null) {
            File dir = new File(DataSyncManager.getInstance().getCachePath() + this.syncFilePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            BufferedReader reader = null;
            PrintWriter writer = null;
            try {
                File syncFile = this.createSyncFile(dir.getAbsolutePath());
                this.mSyncDataFiles.add(syncFile);
                reader = new BufferedReader(new InputStreamReader(is));
                writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(syncFile)));
                String readContent = "";
                while ((readContent = reader.readLine()) != null) {
                    if (DEPART_FILE_SINGLES.equals(readContent)) {
                        writer.flush();
                        writer.close();
                        writer = null;
                        syncFile = this.createSyncFile(dir.getAbsolutePath());
                        this.mSyncDataFiles.add(syncFile);
                        writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(syncFile)));
                        continue;
                    }
                    if (TextUtils.isEmpty((CharSequence)readContent)) continue;
                    writer.println(readContent);
                    this.isJsonSupport = this.isJsonSupport || readContent.trim().startsWith("{");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (writer != null) {
                        writer.flush();
                        writer.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private File createSyncFile(String dir) {
        String name = dir + "/" + UUID.randomUUID().toString() + ".sync";
        File syncFile = new File(name);
        try {
            syncFile.createNewFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return syncFile;
    }

    private void parseFileAndSave() {
        for (File f : this.mSyncDataFiles) {
            HybridSyncParser parser = null;
            boolean isSuccess = false;
            if (this.isJsonSupport) {
                parser = new HybridSyncParser(new SyncJsonParser());
                isSuccess = parser.parseJson(f);
            } else {
                parser = new HybridSyncParser(new SyncXmlParser());
                isSuccess = parser.parseXml(f);
            }
            if (!isSuccess) continue;
            f.delete();
        }
    }
}

