/*
 * Decompiled with CFR 0.152.
 */
package com.boanda.android.sync;

import android.app.Dialog;
import android.content.Context;
import android.text.TextUtils;
import com.boanda.android.sync.DataSyncParams;
import com.boanda.android.sync.DataSyncResponse;
import com.boanda.android.sync.SyncConfig;
import com.boanda.android.sync.SyncServiceEnum;
import com.szboanda.android.platform.db.DbHelper;
import com.szboanda.android.platform.db.SQLiteDao;
import com.szboanda.android.platform.http.HttpTask;
import com.szboanda.android.platform.http.ParamsWrapper;
import com.szboanda.android.platform.http.impl.IProgressChangeView;
import com.szboanda.android.platform.util.JsonUtils;
import com.szboanda.android.platform.util.NetworkUtils;
import com.szboanda.android.platform.util.StringUtils;
import io.reactivex.Flowable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONObject;

public class DataSyncManager {
    public static final String KEY_UNION_TABLES = "UNION_TABLES";
    public static final String KEY_UNION_SYNC_TIMES = "UNION_SYNC_TIMES";
    public static final String KEY_PROTCOL_SUPPORT = "protcol_support";
    private static Object mLock = new Object();
    private static volatile DataSyncManager mInstance = null;
    private static JSONObject SYNC_FREEZE_INTERVAL = new JSONObject();
    private Context mContext;
    private SyncConfig mParamConfig;

    private DataSyncManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSyncManager getInstance() {
        if (mInstance == null) {
            Object object = mLock;
            synchronized (object) {
                if (mInstance == null) {
                    mInstance = new DataSyncManager();
                }
            }
        }
        return mInstance;
    }

    public void init(Context context, SyncConfig config) {
        this.mContext = context;
        this.mParamConfig = config;
    }

    public SyncConfig getParamConfig() {
        return this.mParamConfig;
    }

    public void syncTableAsync(Context context, String ... tables) {
        this.syncTableAsync(context, (IProgressChangeView)null, tables);
    }

    public void syncTableAsync(Context context, IProgressChangeView progress, String ... tables) {
        this.syncTableAsync(context, progress, (Runnable)null, tables);
    }

    public void syncTableAsync(Context context, final IProgressChangeView progress, final Runnable callback, String ... tables) {
        if (progress != null && progress instanceof Dialog) {
            ((Dialog)progress).show();
        }
        Flowable.just((Object)tables).subscribeOn(Schedulers.io()).map((Function)new Function<String[], Boolean>(){

            public Boolean apply(String[] tables) throws Exception {
                DataSyncManager.this.syncTable(tables);
                return true;
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Boolean>(){

            public void accept(Boolean aBoolean) throws Exception {
                if (progress != null && progress instanceof Dialog && ((Dialog)progress).isShowing()) {
                    ((Dialog)progress).dismiss();
                }
                if (callback != null) {
                    callback.run();
                }
            }
        });
    }

    public synchronized void syncTable(String tableName) {
        if (NetworkUtils.isNetworkOpened((Context)this.mContext)) {
            DataSyncParams params = new DataSyncParams();
            params.addQueryStringParameter("service", SyncServiceEnum.DATASYNC_REQUEST.toString());
            params.addQueryStringParameter("lastSyncTime", this.getLastSyncTime(tableName));
            params.addQueryStringParameter("table", tableName);
            HttpTask syncTask = new HttpTask(null);
            long start = System.currentTimeMillis();
            DataSyncResponse dataSyncResponse = (DataSyncResponse)syncTask.sendRequest((ParamsWrapper)params, DataSyncResponse.class);
        }
    }

    public void syncTable(String ... tables) {
        String[] tableArray = tables;
        List<String> tableList = Arrays.asList(tableArray);
        this.syncTables(tableList);
    }

    public void syncTable(Class<?> ... entitys) {
        Class<?>[] entityArray = entitys;
        ArrayList<String> tableList = new ArrayList<String>();
        SQLiteDao dao = DbHelper.getDao();
        for (Class<?> cls : entityArray) {
            try {
                String name = dao.getTable(cls).getName();
                tableList.add(name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.syncTables(tableList);
    }

    public void syncTable(List<Class<?>> entitys) {
        ArrayList<String> tableList = new ArrayList<String>();
        SQLiteDao dao = DbHelper.getDao();
        for (Class<?> cls : entitys) {
            try {
                tableList.add(dao.getTable(cls).getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.syncTables(tableList);
    }

    public synchronized void syncTables(List<String> tables) {
        if (NetworkUtils.isNetworkOpened((Context)this.mContext)) {
            DataSyncParams params = new DataSyncParams();
            String unionTables = StringUtils.joinStringItem(tables, (String)",");
            ArrayList<String> syncTimeList = new ArrayList<String>();
            for (String tableName : tables) {
                syncTimeList.add(this.getLastSyncTime(tableName));
            }
            String unionSyncTimes = StringUtils.joinStringItem(syncTimeList, (String)",");
            params.addBodyParameter("service", SyncServiceEnum.SYNC_TABLES.toString());
            params.addBodyParameter(KEY_UNION_TABLES, unionTables);
            params.addBodyParameter(KEY_UNION_SYNC_TIMES, unionSyncTimes);
            params.addBodyParameter(KEY_PROTCOL_SUPPORT, "json");
            HttpTask syncTask = new HttpTask(null);
            syncTask.setTimeOut(30000);
            params.setReadTimeout(Integer.MAX_VALUE);
            long start = System.currentTimeMillis();
            syncTask.sendRequest((ParamsWrapper)params, DataSyncResponse.class);
        }
    }

    public String getLastSyncTime(String tableName) {
        return this.getLastSyncTime(null, tableName);
    }

    public String getLastSyncTime(String dbName, String tableName) {
        String sql = "SELECT ifnull(MAX(XGSJ),'') as LASTSYNC FROM " + tableName;
        SQLiteDao dao = DbHelper.getDao((String)dbName);
        JSONObject last = dao.getSingleValue(sql);
        String lastSyncTime = last == null ? "" : last.optString("LASTSYNC");
        return TextUtils.isEmpty((CharSequence)lastSyncTime) ? "-1" : lastSyncTime;
    }

    public void setTableSyncFreezeInterval(String table, int sec) {
        JsonUtils.put((JSONObject)SYNC_FREEZE_INTERVAL, (String)table, (Object)sec);
    }

    public String getCachePath() {
        File cacheFile = this.mContext.getExternalCacheDir();
        if (cacheFile == null) {
            cacheFile = this.mContext.getCacheDir();
        }
        String cachePath = cacheFile.getAbsolutePath() + "/datasync";
        return cachePath;
    }
}

