package com.boanda.android.sync;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;

import android.util.Xml;

public class SyncXmlParser implements ISyncXmlParser{
	
	/**表标签*/
	private final static String TAG_TABLE = "table";
	/**响应时间标签*/
	private final static String TAG_REP_TIME = "response-time";
	/**字段标签*/
	private final static String TAG_FIELD = "field";
	/**数据条目标签*/
	private final static String TAG_DATA_ITEM = "data-item";
	/**数据字段内容标签*/
	private final static String TAG_DATA_FIELD = "data-field";
	
	private String encode = "UTF-8";
	/**响应时间*/
	private long responseTime ;
	/**表字段*/
	private List<DataSyncField> fields = null;
	
	private SyncDaoAdapter mDataSaver;

	@Override
	public boolean parseXml(File syncFile) {
		mDataSaver = new SyncDaoAdapter();
		boolean isSuccess = false;
		try{
			if(syncFile != null && syncFile.exists()){
				XmlPullParser parser = Xml.newPullParser();
				InputStream input = null;
				try{
					input = new BufferedInputStream(new FileInputStream(syncFile));
					parser.setInput(input, encode);
					int eventType = parser.getEventType();
					while (eventType != XmlPullParser.END_DOCUMENT) {
						switch (eventType) {
						case XmlPullParser.START_DOCUMENT:
							fields = new ArrayList<DataSyncField>();
							break;
						case XmlPullParser.START_TAG:
							parseTag(parser);
							break;
						default:
							break;
						}
						eventType = parser.next();
					}
					//解析结束
					mDataSaver.end();
					isSuccess = true;
				}catch (Exception e) {
					e.printStackTrace();
				}finally{
					try{
						input.close();
						input = null;
					}catch (Exception e) {
						e.printStackTrace();
					}
				}
			}
		}catch(Exception e){
			e.printStackTrace();
		}
		return isSuccess;
	}

	/**
	 * 解析标签
	 * @param parser
	 */
	private void parseTag(XmlPullParser parser){
		try{
			String tagName = parser.getName();
			if(TAG_TABLE.equals(tagName)){
				String tableName = parser.nextText();
				mDataSaver.setTableName(tableName);
			}else if(TAG_REP_TIME.equals(tagName)){
				responseTime = Long.parseLong(parser.nextText());
			}else if(TAG_FIELD.equals(tagName)){
				parseTableFields(parser);
			}else if(TAG_DATA_ITEM.equals(tagName)){
				JSONObject itemData = parseDataItem(parser);
				mDataSaver.saveData(itemData);
			}
		}catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * 解析表字段
	 * @param parser
	 */
	private void parseTableFields(XmlPullParser parser){
		String name = parser.getAttributeValue("", "name");
		String type = parser.getAttributeValue("", "type");
		boolean isPrimaryKey = Boolean.parseBoolean(parser.getAttributeValue("", "primary_key"));
		DataSyncField field = new DataSyncField();
		field.setName(name);
		field.setType(type);
		field.setPrimaryKey(isPrimaryKey);
		fields.add(field);
	}
	
	/**
	 * 解析数据条目
	 * @param parser
	 * @return
	 */
	private JSONObject parseDataItem(XmlPullParser parser){
		JSONObject result = null;
		try{
			int event = parser.nextTag();
			String name = parser.getName();
			result = new JSONObject();
			//直到</data-item>解析完一条数据
			while (TAG_DATA_FIELD.equals(name) && event == XmlPullParser.START_TAG) {
				String fieldName = parser.getAttributeValue("", "field");
				String fieldValue = parser.nextText();
				result.put(fieldName, fieldValue);
				parser.nextTag();
				name = parser.getName();
			}
		}catch (Exception e) {
			e.printStackTrace();
		}
		return result;
	}
	
	public long getResponseTime(){
		return responseTime;
	}
	

}
