package com.boanda.android.sync;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;

import org.json.JSONArray;
import org.json.JSONObject;

import com.google.gson.stream.JsonReader;
import com.szboanda.android.platform.util.FileUtils;
import com.szboanda.android.platform.util.JsonUtils;

import android.text.TextUtils;
import android.util.Log;

/**
 * <p>Description: json同步数据解析器</p>
 * @author    Siyi Lu    Create Date: 2016年11月21日
 */
public class SyncJsonParser implements ISyncJsonParser{
	
	/**键-table*/
	public final static String KEY_TABLE = "table";
	
	/**键-table*/
	public final static String KEY_DATA_ARRAY = "data_array";
	
	private SyncDaoAdapter mDataSaver = null;

	@Override
	public boolean parseJson(File syncJsonFile) {
		mDataSaver = new SyncDaoAdapter();
		boolean isSuccess = false;
		if(syncJsonFile != null && syncJsonFile.exists()){
			isSuccess = parseReadInWhole(syncJsonFile);
			mDataSaver.end();
		}
		return isSuccess;
	}
	
	private boolean parseReadInWhole(File syncFile){
		boolean isSuccess = false;
		try {
			String content = FileUtils.readContent(syncFile.getAbsolutePath());
			if(!TextUtils.isEmpty(content)){
				JSONObject data = JsonUtils.parseJsonObject(content);
				if(data != null){
					String tableName = data.optString(KEY_TABLE);
					mDataSaver.setTableName(tableName);
					JSONArray dataArray = data.optJSONArray(KEY_DATA_ARRAY);
					if(dataArray != null){
						for(int i = 0; i < dataArray.length(); i++){
							JSONObject item = dataArray.optJSONObject(i);
							mDataSaver.saveData(item);
						}
					}
					isSuccess = true;
				}
			}
		} catch (Exception e) {
            Log.e("SyncSaveError", mDataSaver.getTableName());
			e.printStackTrace();
		}
		return isSuccess;
	}
	
	/**
	 * 通过流的形式读Json，修复一次性把内容读到内存导致内存溢出的bug，
	 * 但是由于数据中存在json字符串的情况，解析仍然存在问题，暂时保留做后续完善
	 * @param syncFile
	 * @return
	 */
	@SuppressWarnings("unused")
	private boolean parseReadInStream(File syncFile){
		boolean isSuccess = false;
		InputStreamReader streamReader = null;
		try {
			streamReader = new InputStreamReader(new FileInputStream(syncFile), "utf-8");
			JsonReader reader = new JsonReader(streamReader);
			reader.beginObject();
			while (reader.hasNext()) {
				String key = reader.nextName();
				if(KEY_TABLE.equals(key)){
					String table = reader.nextString();
					mDataSaver.setTableName(table);
				}else{
					beginArray(reader);
				}
			}
			reader.endObject();
		} catch (Exception e) {
			e.printStackTrace();
		}finally{
			try {
				if(streamReader != null){
					streamReader.close();
				}
			} catch (Exception e2) {
				e2.printStackTrace();
			}
		}
		return isSuccess;
	}
	
	private void beginArray(JsonReader reader){
		try {
			reader.beginArray();
			while (reader.hasNext()) {
				parseItemJson(reader);
			}
			reader.endArray();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private void parseItemJson(JsonReader reader){
		try {
			reader.beginObject();
			JSONObject item = new JSONObject();
			while (reader.hasNext()) {
				String key = reader.nextName();
				String value = reader.nextString();
				item.accumulate(key, value);
			}
			mDataSaver.saveData(item);
			reader.endObject();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
