package com.boanda.android.sync;

import android.text.TextUtils;

import com.szboanda.android.platform.http.ParamsWrapper;

import java.util.Map;
import java.util.Set;

/**
 * Created by Administrator on 2017/7/3.
 */

public class DataSyncParams extends ParamsWrapper {

    public DataSyncParams(){
        super();
        SyncConfig config = DataSyncManager.getInstance().getParamConfig();
        if(config != null){
            setUri(config.getServiceUrl());
            Map<String, String> residents = config.getResident();
            Set<String> keys = residents.keySet();
            for (String key : keys){
                addQueryStringParameter(key, residents.get(key));
            }
            if(!TextUtils.isEmpty(config.getUserId())) {
                addQueryStringParameter("userid", config.getUserId());
                addQueryStringParameter("password", config.getPassword());
                addQueryStringParameter("orgid", config.getOrgid());
            }
        }
    }

}
