package com.boanda.android.graphic.adaptee;

import android.content.Context;
import android.view.View;

import com.boanda.android.graphic.DisplayOption;
import com.boanda.android.graphic.IBitmapLoader;
import com.boanda.android.graphic.ILoaderCallbak;

/**
 * IBitmapLoader的存根类
 * Created by Administrator on 2017/3/17.
 */

public abstract class BitmapLoaderStub implements IBitmapLoader {

    @Override
    public abstract void init(Context context);

    @Override
    public abstract boolean enable();

    @Override
    public void load(View targetView, String uri) {
        load(targetView, uri, null, null);
    }

    @Override
    public void load(View targetView, String uri, DisplayOption option) {
        load(targetView, uri, option, null);
    }

    @Override
    public void load(View targetView, String uri, ILoaderCallbak callbak) {
        load(targetView, uri, null, callbak);
    }

    @Override
    public abstract void load(View targetView, String uri, DisplayOption option, ILoaderCallbak callbak);
}
