/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.db.table;

import android.database.Cursor;
import android.text.TextUtils;
import java.util.HashMap;
import org.xutils.DbManager;
import org.xutils.common.util.IOUtil;
import org.xutils.common.util.LogUtil;
import org.xutils.db.sqlite.SqlInfo;
import org.xutils.db.sqlite.SqlInfoBuilder;
import org.xutils.db.table.ColumnEntity;
import org.xutils.db.table.TableEntity;
import org.xutils.ex.DbException;

public abstract class DbBase
implements DbManager {
    private final HashMap<Class<?>, TableEntity<?>> tableMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> TableEntity<T> getTable(Class<T> entityType) throws DbException {
        HashMap<Class<?>, TableEntity<?>> hashMap = this.tableMap;
        synchronized (hashMap) {
            TableEntity<Object> table = this.tableMap.get(entityType);
            if (table == null) {
                try {
                    table = new TableEntity<T>(this, entityType);
                }
                catch (Throwable ex) {
                    throw new DbException(ex);
                }
                this.tableMap.put(entityType, table);
            }
            return table;
        }
    }

    @Override
    public void dropTable(Class<?> entityType) throws DbException {
        TableEntity<?> table = this.getTable(entityType);
        if (!table.tableIsExist()) {
            return;
        }
        this.execNonQuery("DROP TABLE \"" + table.getName() + "\"");
        table.setCheckedDatabase(false);
        this.removeTable(entityType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropDb() throws DbException {
        Cursor cursor = this.execQuery("SELECT name FROM sqlite_master WHERE type='table' AND name<>'sqlite_sequence'");
        if (cursor != null) {
            try {
                while (cursor.moveToNext()) {
                    try {
                        String tableName = cursor.getString(0);
                        this.execNonQuery("DROP TABLE " + tableName);
                    }
                    catch (Throwable e) {
                        LogUtil.e(e.getMessage(), e);
                    }
                }
                HashMap<Class<?>, TableEntity<?>> e = this.tableMap;
                synchronized (e) {
                    for (TableEntity<?> table : this.tableMap.values()) {
                        table.setCheckedDatabase(false);
                    }
                    this.tableMap.clear();
                }
            }
            catch (Throwable e) {
                throw new DbException(e);
            }
            finally {
                IOUtil.closeQuietly(cursor);
            }
        }
    }

    @Override
    public void addColumn(Class<?> entityType, String column) throws DbException {
        TableEntity<?> table = this.getTable(entityType);
        ColumnEntity col = table.getColumnMap().get(column);
        if (col != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("ALTER TABLE ").append("\"").append(table.getName()).append("\"").append(" ADD COLUMN ").append("\"").append(col.getName()).append("\"").append(" ").append((Object)col.getColumnDbType()).append(" ").append(col.getProperty());
            this.execNonQuery(builder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTableIfNotExist(TableEntity<?> table) throws DbException {
        if (!table.tableIsExist()) {
            Class<?> clazz = table.getClass();
            synchronized (clazz) {
                if (!table.tableIsExist()) {
                    SqlInfo sqlInfo = SqlInfoBuilder.buildCreateTableSqlInfo(table);
                    this.execNonQuery(sqlInfo);
                    String execAfterTableCreated = table.getOnCreated();
                    if (!TextUtils.isEmpty((CharSequence)execAfterTableCreated)) {
                        this.execNonQuery(execAfterTableCreated);
                    }
                    table.setCheckedDatabase(true);
                    DbManager.TableCreateListener listener = this.getDaoConfig().getTableCreateListener();
                    if (listener != null) {
                        listener.onTableCreated(this, table);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTable(Class<?> entityType) {
        HashMap<Class<?>, TableEntity<?>> hashMap = this.tableMap;
        synchronized (hashMap) {
            this.tableMap.remove(entityType);
        }
    }
}

