/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.common.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public class ParameterizedTypeUtil {
    private ParameterizedTypeUtil() {
    }

    public static Type getParameterizedType(Type ownerType, Class<?> declaredClass, int paramIndex) {
        Class superClass;
        Class clazz = null;
        ParameterizedType pt = null;
        Type[] ats = null;
        TypeVariable<Class<T>>[] tps = null;
        if (ownerType instanceof ParameterizedType) {
            pt = (ParameterizedType)ownerType;
            clazz = (Class)pt.getRawType();
            ats = pt.getActualTypeArguments();
            tps = clazz.getTypeParameters();
        } else {
            clazz = (Class)ownerType;
        }
        if (declaredClass == clazz) {
            if (ats != null) {
                return ats[paramIndex];
            }
            return Object.class;
        }
        Type[] types = clazz.getGenericInterfaces();
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                Class cls;
                Type t = types[i];
                if (!(t instanceof ParameterizedType) || !declaredClass.isAssignableFrom(cls = (Class)((ParameterizedType)t).getRawType())) continue;
                try {
                    return ParameterizedTypeUtil.getTrueType(ParameterizedTypeUtil.getParameterizedType(t, declaredClass, paramIndex), tps, ats);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if ((superClass = clazz.getSuperclass()) != null && declaredClass.isAssignableFrom(superClass)) {
            return ParameterizedTypeUtil.getTrueType(ParameterizedTypeUtil.getParameterizedType(clazz.getGenericSuperclass(), declaredClass, paramIndex), tps, ats);
        }
        throw new IllegalArgumentException("FindGenericType:" + ownerType + ", declaredClass: " + declaredClass + ", index: " + paramIndex);
    }

    private static Type getTrueType(Type type, TypeVariable<?>[] typeVariables, Type[] actualTypes) {
        Type ct;
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            String name = tv.getName();
            if (actualTypes != null) {
                for (int i = 0; i < typeVariables.length; ++i) {
                    if (!name.equals(typeVariables[i].getName())) continue;
                    return actualTypes[i];
                }
            }
            return tv;
        }
        if (type instanceof GenericArrayType && (ct = ((GenericArrayType)type).getGenericComponentType()) instanceof Class) {
            return Array.newInstance((Class)ct, 0).getClass();
        }
        return type;
    }
}

