package com.boanda.android.graphic.adaptee;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;

import com.boanda.android.graphic.BitmapEngine;
import com.boanda.android.graphic.DisplayOption;
import com.boanda.android.graphic.ILoaderCallbak;

import org.xutils.common.Callback;
import org.xutils.image.ImageOptions;
import org.xutils.x;

/**
 * <p>Description：</p>
 *
 * @author Created by Siyi Lu on 2017/2/6.
 * @Company 深圳市博安达信息技术股份有限公司
 */

public class XUtilsLoader extends BitmapLoaderStub {

    @Override
    public void init(Context context) {

    }

    @Override
    public boolean enable() {
        return BitmapEngine.classEnable("org.xutils.x");
    }

    @Override
    public void load(View targetView, final String uri, DisplayOption option, final ILoaderCallbak callbak) {
        if(enable() && targetView != null &&targetView instanceof ImageView){
            ImageOptions options = option != null ? option.getActualOption() : null;
            Callback.CommonCallback actualCallback = callbak == null ? null : new Callback.CommonCallback<Drawable>() {
                @Override
                public void onSuccess(Drawable o) {
                    callbak.loadSuccess(uri);
                }

                @Override
                public void onError(Throwable throwable, boolean b) {
                    callbak.loadFailure(uri, throwable);
                }

                @Override
                public void onCancelled(CancelledException e) {}

                @Override
                public void onFinished() {}
            };
            x.image().bind((ImageView) targetView, uri, options, actualCallback);
        }
    }
}
