package com.boanda.android.graphic;

import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;

import org.xutils.image.ImageOptions;

/**
 * 图片加载参数载体
 * Created by Siyi Lu on 2017/3/17.
 */

public class DisplayOption {

    private ImageOptions mActualOption;

    private DisplayOption(Builder builder){
        mActualOption = builder.getOption();
    }

    public ImageOptions getActualOption(){
        return mActualOption;
    }

    public static class Builder{

        private ImageOptions.Builder mOptionBuilder;

        public Builder(){
            mOptionBuilder = new ImageOptions.Builder();
        }

        public Builder animate(int animationId){
            Animation anim = AnimationUtils.loadAnimation(BitmapEngine.getContext(), animationId);
            mOptionBuilder.setAnimation(anim);
            return this;
        }

        public Builder autoRotate(boolean autoRotate){
            mOptionBuilder.setAutoRotate(autoRotate);
            return this;
        }


        public Builder dimen(int width, int height){
            mOptionBuilder.setSize(width, height);
            return this;
        }

        public Builder crop(boolean crop){
            mOptionBuilder.setCrop(crop);
            return this;
        }

        public Builder fadeIn(boolean fadeIn){
            mOptionBuilder.setFadeIn(fadeIn);
            return this;
        }

        public Builder failureDrawableId(int failureDrawableId){
            mOptionBuilder.setFailureDrawableId(failureDrawableId);
            return this;
        }

        public Builder ignoreGif(boolean ignoreGif){
            mOptionBuilder.setIgnoreGif(ignoreGif);
            return this;
        }

        public Builder loadingDrawableId(int loadingDrawableId){
            mOptionBuilder.setLoadingDrawableId(loadingDrawableId);
            return this;
        }

        public Builder placeholderScaleType(ImageView.ScaleType type){
            mOptionBuilder.setPlaceholderScaleType(type);
            return this;
        }

        public Builder radius(int radius){
            mOptionBuilder.setRadius(radius);
            return this;
        }

        public Builder square(boolean square){
            mOptionBuilder.setSquare(square);
            return this;
        }

        public Builder circular(boolean circular){
            mOptionBuilder.setCircular(circular);
            return this;
        }

        public Builder scaleType(ImageView.ScaleType type){
            mOptionBuilder.setImageScaleType(type);
            return this;
        }

        protected ImageOptions getOption(){
            return mOptionBuilder.build();
        }

        public DisplayOption build(){
            DisplayOption option = new DisplayOption(this);
            return option;
        }

    }


}
