/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo;

import android.content.Context;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Handler;
import android.util.Base64;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.artifex.mupdfdemo.Annotation;
import com.artifex.mupdfdemo.AsyncTask;
import com.artifex.mupdfdemo.Hit;
import com.artifex.mupdfdemo.LinkInfo;
import com.artifex.mupdfdemo.MuPDFCore;
import com.artifex.mupdfdemo.MuPDFView;

public class MuPDFReflowView
extends WebView
implements MuPDFView {
    private final MuPDFCore mCore;
    private final Handler mHandler = new Handler();
    private final Point mParentSize;
    private int mPage;
    private int mContentHeight;
    AsyncTask<Void, Void, byte[]> mLoadHTML;

    public MuPDFReflowView(Context c, MuPDFCore core, Point parentSize) {
        super(c);
        this.mCore = core;
        this.mParentSize = parentSize;
        this.mContentHeight = parentSize.y;
        this.getSettings().setJavaScriptEnabled(true);
        this.addJavascriptInterface(new Object(){

            public void reportContentHeight(String value) {
                MuPDFReflowView.this.mContentHeight = (int)Float.parseFloat(value);
                MuPDFReflowView.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        MuPDFReflowView.this.requestLayout();
                    }
                });
            }
        }, "HTMLOUT");
        this.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                MuPDFReflowView.this.requestHeight();
            }
        });
    }

    private void requestHeight() {
        this.loadUrl("javascript:elem=document.getElementById('content');window.HTMLOUT.reportContentHeight(" + this.mParentSize.x + "*elem.offsetHeight/elem.offsetWidth)");
    }

    @Override
    public void setPage(int page, PointF size) {
        this.mPage = page;
        if (this.mLoadHTML != null) {
            this.mLoadHTML.cancel(true);
        }
        this.mLoadHTML = new AsyncTask<Void, Void, byte[]>(){

            protected byte[] doInBackground(Void ... params) {
                return MuPDFReflowView.this.mCore.html(MuPDFReflowView.this.mPage);
            }

            @Override
            protected void onPostExecute(byte[] result) {
                String b64 = Base64.encodeToString((byte[])result, (int)0);
                MuPDFReflowView.this.loadData(b64, "text/html; charset=utf-8", "base64");
            }
        };
        this.mLoadHTML.execute((Void[])new Void[0]);
    }

    @Override
    public int getPage() {
        return this.mPage;
    }

    @Override
    public void setScale(float scale) {
        this.loadUrl("javascript:document.getElementById('content').style.zoom=\"" + (int)(scale * 100.0f) + "%\"");
        this.requestHeight();
    }

    @Override
    public void blank(int page) {
    }

    @Override
    public Hit passClickEvent(float x, float y) {
        return Hit.Nothing;
    }

    @Override
    public LinkInfo hitLink(float x, float y) {
        return null;
    }

    @Override
    public void selectText(float x0, float y0, float x1, float y1) {
    }

    @Override
    public void deselectText() {
    }

    @Override
    public boolean copySelection() {
        return false;
    }

    @Override
    public boolean markupSelection(Annotation.Type type) {
        return false;
    }

    @Override
    public void startDraw(float x, float y) {
    }

    @Override
    public void continueDraw(float x, float y) {
    }

    @Override
    public void cancelDraw() {
    }

    @Override
    public boolean saveDraw() {
        return false;
    }

    @Override
    public void setSearchBoxes(RectF[] searchBoxes) {
    }

    @Override
    public void setLinkHighlighting(boolean f) {
    }

    @Override
    public void deleteSelectedAnnotation() {
    }

    @Override
    public void deselectAnnotation() {
    }

    @Override
    public void setChangeReporter(Runnable reporter) {
    }

    @Override
    public void update() {
    }

    @Override
    public void addHq(boolean update) {
    }

    @Override
    public void removeHq() {
    }

    @Override
    public void releaseResources() {
        if (this.mLoadHTML != null) {
            this.mLoadHTML.cancel(true);
            this.mLoadHTML = null;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int y;
        int x;
        switch (View.MeasureSpec.getMode((int)widthMeasureSpec)) {
            case 0: {
                x = this.mParentSize.x;
                break;
            }
            default: {
                x = View.MeasureSpec.getSize((int)widthMeasureSpec);
            }
        }
        switch (View.MeasureSpec.getMode((int)heightMeasureSpec)) {
            case 0: {
                y = this.mContentHeight;
                break;
            }
            default: {
                y = View.MeasureSpec.getSize((int)heightMeasureSpec);
            }
        }
        this.setMeasuredDimension(x, y);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        return false;
    }
}

