/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.view;

import android.text.TextUtils;
import android.view.View;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.xutils.common.util.DoubleKeyValueMap;
import org.xutils.common.util.LogUtil;
import org.xutils.view.ViewFinder;
import org.xutils.view.ViewInfo;
import org.xutils.view.annotation.Event;

final class EventListenerManager {
    private static final long QUICK_EVENT_TIME_SPAN = 300L;
    private static final HashSet<String> AVOID_QUICK_EVENT_SET = new HashSet(2);
    private static final DoubleKeyValueMap<ViewInfo, Class<?>, Object> listenerCache;

    private EventListenerManager() {
    }

    public static void addEventMethod(ViewFinder finder, ViewInfo info, Event event, Object handler, Method method) {
        try {
            View view = finder.findViewByInfo(info);
            if (view != null) {
                Class<?> listenerType = event.type();
                String listenerSetter = event.setter();
                if (TextUtils.isEmpty((CharSequence)listenerSetter)) {
                    listenerSetter = "set" + listenerType.getSimpleName();
                }
                String methodName = event.method();
                boolean addNewMethod = false;
                Object listener = listenerCache.get(info, listenerType);
                DynamicHandler dynamicHandler = null;
                if (listener != null && (addNewMethod = handler.equals((dynamicHandler = (DynamicHandler)Proxy.getInvocationHandler(listener)).getHandler()))) {
                    dynamicHandler.addMethod(methodName, method);
                }
                if (!addNewMethod) {
                    dynamicHandler = new DynamicHandler(handler);
                    dynamicHandler.addMethod(methodName, method);
                    listener = Proxy.newProxyInstance(listenerType.getClassLoader(), new Class[]{listenerType}, (InvocationHandler)dynamicHandler);
                    listenerCache.put(info, listenerType, listener);
                }
                Method setEventListenerMethod = view.getClass().getMethod(listenerSetter, listenerType);
                setEventListenerMethod.invoke((Object)view, listener);
            }
        }
        catch (Throwable ex) {
            LogUtil.e(ex.getMessage(), ex);
        }
    }

    static {
        AVOID_QUICK_EVENT_SET.add("onClick");
        AVOID_QUICK_EVENT_SET.add("onItemClick");
        listenerCache = new DoubleKeyValueMap();
    }

    public static class DynamicHandler
    implements InvocationHandler {
        private WeakReference<Object> handlerRef;
        private final HashMap<String, Method> methodMap = new HashMap(1);
        private static long lastClickTime = 0L;

        public DynamicHandler(Object handler) {
            this.handlerRef = new WeakReference<Object>(handler);
        }

        public void addMethod(String name, Method method) {
            this.methodMap.put(name, method);
        }

        public Object getHandler() {
            return this.handlerRef.get();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object handler = this.handlerRef.get();
            if (handler != null) {
                Map.Entry<String, Method> entry;
                Iterator<Map.Entry<String, Method>> iterator;
                String eventMethod = method.getName();
                if ("toString".equals(eventMethod)) {
                    return DynamicHandler.class.getSimpleName();
                }
                method = this.methodMap.get(eventMethod);
                if (method == null && this.methodMap.size() == 1 && (iterator = this.methodMap.entrySet().iterator()).hasNext() && TextUtils.isEmpty((CharSequence)(entry = iterator.next()).getKey())) {
                    method = entry.getValue();
                }
                if (method != null) {
                    if (AVOID_QUICK_EVENT_SET.contains(eventMethod)) {
                        long timeSpan = System.currentTimeMillis() - lastClickTime;
                        if (timeSpan < 300L) {
                            LogUtil.d("onClick cancelled: " + timeSpan);
                            return null;
                        }
                        lastClickTime = System.currentTimeMillis();
                    }
                    try {
                        return method.invoke(handler, args);
                    }
                    catch (Throwable ex) {
                        throw new RuntimeException("invoke method error:" + handler.getClass().getName() + "#" + method.getName(), ex);
                    }
                }
                LogUtil.w("method not impl: " + eventMethod + "(" + handler.getClass().getSimpleName() + ")");
            }
            return null;
        }
    }
}

