/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.http.cookie;

import android.text.TextUtils;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.xutils.DbManager;
import org.xutils.common.task.PriorityExecutor;
import org.xutils.common.util.LogUtil;
import org.xutils.config.DbConfigs;
import org.xutils.db.Selector;
import org.xutils.db.sqlite.WhereBuilder;
import org.xutils.db.table.DbModel;
import org.xutils.http.cookie.CookieEntity;
import org.xutils.x;

public enum DbCookieStore implements CookieStore
{
    INSTANCE;

    private final DbManager db;
    private final Executor trimExecutor = new PriorityExecutor(1, true);
    private static final int LIMIT_COUNT = 5000;
    private long lastTrimTime = 0L;
    private static final long TRIM_TIME_SPAN = 1000L;

    private DbCookieStore() {
        this.db = x.getDb(DbConfigs.COOKIE.getConfig());
        try {
            this.db.delete(CookieEntity.class, WhereBuilder.b("expiry", "=", -1L));
        }
        catch (Throwable ex) {
            LogUtil.e(ex.getMessage(), ex);
        }
    }

    @Override
    public void add(URI uri, HttpCookie cookie) {
        if (cookie == null) {
            return;
        }
        uri = this.getEffectiveURI(uri);
        try {
            this.db.replace(new CookieEntity(uri, cookie));
        }
        catch (Throwable ex) {
            LogUtil.e(ex.getMessage(), ex);
        }
        this.trimSize();
    }

    @Override
    public List<HttpCookie> get(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri is null");
        }
        uri = this.getEffectiveURI(uri);
        ArrayList<HttpCookie> rt = new ArrayList<HttpCookie>();
        try {
            String path;
            Selector<CookieEntity> selector = this.db.selector(CookieEntity.class);
            WhereBuilder where = WhereBuilder.b();
            String host = uri.getHost();
            if (!TextUtils.isEmpty((CharSequence)host)) {
                String domain;
                WhereBuilder subWhere = WhereBuilder.b("domain", "=", host).or("domain", "=", "." + host);
                int firstDot = host.indexOf(".");
                int lastDot = host.lastIndexOf(".");
                if (firstDot > 0 && lastDot > firstDot && !TextUtils.isEmpty((CharSequence)(domain = host.substring(firstDot, host.length())))) {
                    subWhere.or("domain", "=", domain);
                }
                where.and(subWhere);
            }
            if (!TextUtils.isEmpty((CharSequence)(path = uri.getPath()))) {
                WhereBuilder subWhere = WhereBuilder.b("path", "=", path).or("path", "=", "/").or("path", "=", null);
                int lastSplit = path.lastIndexOf("/");
                while (lastSplit > 0) {
                    path = path.substring(0, lastSplit);
                    subWhere.or("path", "=", path);
                    lastSplit = path.lastIndexOf("/");
                }
                where.and(subWhere);
            }
            where.or("uri", "=", uri.toString());
            List<CookieEntity> cookieEntityList = selector.where(where).findAll();
            if (cookieEntityList != null) {
                for (CookieEntity cookieEntity : cookieEntityList) {
                    if (cookieEntity.isExpired()) continue;
                    rt.add(cookieEntity.toHttpCookie());
                }
            }
        }
        catch (Throwable ex) {
            LogUtil.e(ex.getMessage(), ex);
        }
        return rt;
    }

    @Override
    public List<HttpCookie> getCookies() {
        ArrayList<HttpCookie> rt = new ArrayList<HttpCookie>();
        try {
            List<CookieEntity> cookieEntityList = this.db.findAll(CookieEntity.class);
            if (cookieEntityList != null) {
                for (CookieEntity cookieEntity : cookieEntityList) {
                    if (cookieEntity.isExpired()) continue;
                    rt.add(cookieEntity.toHttpCookie());
                }
            }
        }
        catch (Throwable ex) {
            LogUtil.e(ex.getMessage(), ex);
        }
        return rt;
    }

    @Override
    public List<URI> getURIs() {
        ArrayList<URI> uris = new ArrayList<URI>();
        try {
            List<DbModel> uriList = this.db.selector(CookieEntity.class).select("uri").findAll();
            if (uriList != null) {
                for (DbModel model : uriList) {
                    String uri = model.getString("uri");
                    if (TextUtils.isEmpty((CharSequence)uri)) continue;
                    try {
                        uris.add(new URI(uri));
                    }
                    catch (Throwable ex) {
                        LogUtil.e(ex.getMessage(), ex);
                        try {
                            this.db.delete(CookieEntity.class, WhereBuilder.b("uri", "=", uri));
                        }
                        catch (Throwable ignored) {
                            LogUtil.e(ignored.getMessage(), ignored);
                        }
                    }
                }
            }
        }
        catch (Throwable ex) {
            LogUtil.e(ex.getMessage(), ex);
        }
        return uris;
    }

    @Override
    public boolean remove(URI uri, HttpCookie cookie) {
        if (cookie == null) {
            return true;
        }
        boolean modified = false;
        try {
            String path;
            WhereBuilder where = WhereBuilder.b("name", "=", cookie.getName());
            String domain = cookie.getDomain();
            if (!TextUtils.isEmpty((CharSequence)domain)) {
                where.and("domain", "=", domain);
            }
            if (!TextUtils.isEmpty((CharSequence)(path = cookie.getPath()))) {
                if (path.length() > 1 && path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                where.and("path", "=", path);
            }
            this.db.delete(CookieEntity.class, where);
            modified = true;
        }
        catch (Throwable ex) {
            LogUtil.e(ex.getMessage(), ex);
        }
        return modified;
    }

    @Override
    public boolean removeAll() {
        try {
            this.db.delete(CookieEntity.class);
        }
        catch (Throwable ex) {
            LogUtil.e(ex.getMessage(), ex);
        }
        return true;
    }

    private void trimSize() {
        this.trimExecutor.execute(new Runnable(){

            @Override
            public void run() {
                long current = System.currentTimeMillis();
                if (current - DbCookieStore.this.lastTrimTime < 1000L) {
                    return;
                }
                DbCookieStore.this.lastTrimTime = current;
                try {
                    DbCookieStore.this.db.delete(CookieEntity.class, WhereBuilder.b("expiry", "<", System.currentTimeMillis()).and("expiry", "!=", -1L));
                }
                catch (Throwable ex) {
                    LogUtil.e(ex.getMessage(), ex);
                }
                try {
                    List<CookieEntity> rmList;
                    int count = (int)DbCookieStore.this.db.selector(CookieEntity.class).count();
                    if (count > 5010 && (rmList = DbCookieStore.this.db.selector(CookieEntity.class).where("expiry", "!=", -1L).orderBy("expiry", false).limit(count - 5000).findAll()) != null) {
                        DbCookieStore.this.db.delete(rmList);
                    }
                }
                catch (Throwable ex) {
                    LogUtil.e(ex.getMessage(), ex);
                }
            }
        });
    }

    private URI getEffectiveURI(URI uri) {
        URI effectiveURI = null;
        try {
            effectiveURI = new URI("http", uri.getHost(), uri.getPath(), null, null);
        }
        catch (Throwable ignored) {
            effectiveURI = uri;
        }
        return effectiveURI;
    }
}

