/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.http;

import android.text.TextUtils;
import java.net.Proxy;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLSocketFactory;
import org.xutils.common.task.Priority;
import org.xutils.common.util.LogUtil;
import org.xutils.http.BaseParams;
import org.xutils.http.RequestParamsHelper;
import org.xutils.http.annotation.HttpRequest;
import org.xutils.http.app.DefaultParamsBuilder;
import org.xutils.http.app.HttpRetryHandler;
import org.xutils.http.app.ParamsBuilder;
import org.xutils.http.app.RedirectHandler;
import org.xutils.http.app.RequestTracker;

public class RequestParams
extends BaseParams {
    private HttpRequest httpRequest;
    private String uri;
    private final String[] signs;
    private final String[] cacheKeys;
    private ParamsBuilder builder;
    private String buildUri;
    private String buildCacheKey;
    private SSLSocketFactory sslSocketFactory;
    private Proxy proxy;
    private boolean useCookie = true;
    private String cacheDirName;
    private long cacheSize;
    private long cacheMaxAge;
    private Executor executor;
    private Priority priority = Priority.DEFAULT;
    private int connectTimeout = 15000;
    private int readTimeout = 15000;
    private boolean autoResume = true;
    private boolean autoRename = false;
    private int maxRetryCount = 2;
    private String saveFilePath;
    private boolean cancelFast = false;
    private int loadingUpdateMaxTimeSpan = 300;
    private HttpRetryHandler httpRetryHandler;
    private RedirectHandler redirectHandler;
    private RequestTracker requestTracker;
    private boolean invokedGetHttpRequest = false;

    public RequestParams() {
        this(null, null, null, null);
    }

    public RequestParams(String uri) {
        this(uri, null, null, null);
    }

    public RequestParams(String uri, ParamsBuilder builder, String[] signs, String[] cacheKeys) {
        if (uri != null && builder == null) {
            builder = new DefaultParamsBuilder();
        }
        this.uri = uri;
        this.signs = signs;
        this.cacheKeys = cacheKeys;
        this.builder = builder;
    }

    void init() throws Throwable {
        if (!TextUtils.isEmpty((CharSequence)this.buildUri)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.uri) && this.getHttpRequest() == null) {
            throw new IllegalStateException("uri is empty && @HttpRequest == null");
        }
        this.initEntityParams();
        this.buildUri = this.uri;
        HttpRequest httpRequest = this.getHttpRequest();
        if (httpRequest != null) {
            this.builder = httpRequest.builder().newInstance();
            this.buildUri = this.builder.buildUri(this, httpRequest);
            this.builder.buildParams(this);
            this.builder.buildSign(this, httpRequest.signs());
            if (this.sslSocketFactory == null) {
                this.sslSocketFactory = this.builder.getSSLSocketFactory();
            }
        } else if (this.builder != null) {
            this.builder.buildParams(this);
            this.builder.buildSign(this, this.signs);
            if (this.sslSocketFactory == null) {
                this.sslSocketFactory = this.builder.getSSLSocketFactory();
            }
        }
    }

    public String getUri() {
        return TextUtils.isEmpty((CharSequence)this.buildUri) ? this.uri : this.buildUri;
    }

    public void setUri(String uri) {
        if (TextUtils.isEmpty((CharSequence)this.buildUri)) {
            this.uri = uri;
        } else {
            this.buildUri = uri;
        }
    }

    public String getCacheKey() {
        if (TextUtils.isEmpty((CharSequence)this.buildCacheKey) && this.builder != null) {
            HttpRequest httpRequest = this.getHttpRequest();
            this.buildCacheKey = httpRequest != null ? this.builder.buildCacheKey(this, httpRequest.cacheKeys()) : this.builder.buildCacheKey(this, this.cacheKeys);
        }
        return this.buildCacheKey;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public boolean isUseCookie() {
        return this.useCookie;
    }

    public void setUseCookie(boolean useCookie) {
        this.useCookie = useCookie;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        if (connectTimeout > 0) {
            this.connectTimeout = connectTimeout;
        }
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        if (readTimeout > 0) {
            this.readTimeout = readTimeout;
        }
    }

    public String getCacheDirName() {
        return this.cacheDirName;
    }

    public void setCacheDirName(String cacheDirName) {
        this.cacheDirName = cacheDirName;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
    }

    public long getCacheMaxAge() {
        return this.cacheMaxAge;
    }

    public void setCacheMaxAge(long cacheMaxAge) {
        this.cacheMaxAge = cacheMaxAge;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public boolean isAutoResume() {
        return this.autoResume;
    }

    public void setAutoResume(boolean autoResume) {
        this.autoResume = autoResume;
    }

    public boolean isAutoRename() {
        return this.autoRename;
    }

    public void setAutoRename(boolean autoRename) {
        this.autoRename = autoRename;
    }

    public String getSaveFilePath() {
        return this.saveFilePath;
    }

    public void setSaveFilePath(String saveFilePath) {
        this.saveFilePath = saveFilePath;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public void setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    public boolean isCancelFast() {
        return this.cancelFast;
    }

    public void setCancelFast(boolean cancelFast) {
        this.cancelFast = cancelFast;
    }

    public int getLoadingUpdateMaxTimeSpan() {
        return this.loadingUpdateMaxTimeSpan;
    }

    public void setLoadingUpdateMaxTimeSpan(int loadingUpdateMaxTimeSpan) {
        this.loadingUpdateMaxTimeSpan = loadingUpdateMaxTimeSpan;
    }

    public HttpRetryHandler getHttpRetryHandler() {
        return this.httpRetryHandler;
    }

    public void setHttpRetryHandler(HttpRetryHandler httpRetryHandler) {
        this.httpRetryHandler = httpRetryHandler;
    }

    public RedirectHandler getRedirectHandler() {
        return this.redirectHandler;
    }

    public void setRedirectHandler(RedirectHandler redirectHandler) {
        this.redirectHandler = redirectHandler;
    }

    public RequestTracker getRequestTracker() {
        return this.requestTracker;
    }

    public void setRequestTracker(RequestTracker requestTracker) {
        this.requestTracker = requestTracker;
    }

    private void initEntityParams() {
        RequestParamsHelper.parseKV(this, this.getClass(), new RequestParamsHelper.ParseKVListener(){

            @Override
            public void onParseKV(String name, Object value) {
                RequestParams.this.addParameter(name, value);
            }
        });
    }

    private HttpRequest getHttpRequest() {
        if (this.httpRequest == null && !this.invokedGetHttpRequest) {
            this.invokedGetHttpRequest = true;
            Class<?> thisCls = this.getClass();
            if (thisCls != RequestParams.class) {
                this.httpRequest = thisCls.getAnnotation(HttpRequest.class);
            }
        }
        return this.httpRequest;
    }

    @Override
    public String toString() {
        try {
            this.init();
        }
        catch (Throwable ex) {
            LogUtil.e(ex.getMessage(), ex);
        }
        String url = this.getUri();
        return TextUtils.isEmpty((CharSequence)url) ? super.toString() : url + (url.contains("?") ? "&" : "?") + super.toString();
    }
}

