/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.db;

import android.database.Cursor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.xutils.db.table.ColumnEntity;
import org.xutils.db.table.DbModel;
import org.xutils.db.table.TableEntity;

final class CursorUtils {
    CursorUtils() {
    }

    public static <T> T getEntity(TableEntity<T> table, Cursor cursor) throws Throwable {
        T entity = table.createEntity();
        LinkedHashMap<String, ColumnEntity> columnMap = table.getColumnMap();
        int columnCount = cursor.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            String columnName = cursor.getColumnName(i);
            ColumnEntity column = (ColumnEntity)((HashMap)columnMap).get(columnName);
            if (column == null) continue;
            column.setValueFromCursor(entity, cursor, i);
        }
        return entity;
    }

    public static DbModel getDbModel(Cursor cursor) {
        DbModel result = new DbModel();
        int columnCount = cursor.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            result.add(cursor.getColumnName(i), cursor.getString(i));
        }
        return result;
    }
}

