/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.common.task;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import java.util.concurrent.Executor;
import org.xutils.common.Callback;
import org.xutils.common.task.AbsTask;
import org.xutils.common.task.Priority;
import org.xutils.common.task.PriorityExecutor;
import org.xutils.common.task.PriorityRunnable;
import org.xutils.common.util.LogUtil;
import org.xutils.x;

class TaskProxy<ResultType>
extends AbsTask<ResultType> {
    static final InternalHandler sHandler = new InternalHandler();
    static final PriorityExecutor sDefaultExecutor = new PriorityExecutor(true);
    private final AbsTask<ResultType> task;
    private final Executor executor;
    private volatile boolean callOnCanceled = false;
    private volatile boolean callOnFinished = false;
    private static final int MSG_WHAT_BASE = 1000000000;
    private static final int MSG_WHAT_ON_WAITING = 1000000001;
    private static final int MSG_WHAT_ON_START = 1000000002;
    private static final int MSG_WHAT_ON_SUCCESS = 1000000003;
    private static final int MSG_WHAT_ON_ERROR = 1000000004;
    private static final int MSG_WHAT_ON_UPDATE = 1000000005;
    private static final int MSG_WHAT_ON_CANCEL = 1000000006;
    private static final int MSG_WHAT_ON_FINISHED = 1000000007;

    TaskProxy(AbsTask<ResultType> task) {
        super(task);
        this.task = task;
        this.task.setTaskProxy(this);
        this.setTaskProxy(null);
        Executor taskExecutor = task.getExecutor();
        if (taskExecutor == null) {
            taskExecutor = sDefaultExecutor;
        }
        this.executor = taskExecutor;
    }

    @Override
    protected final ResultType doBackground() throws Throwable {
        this.onWaiting();
        PriorityRunnable runnable = new PriorityRunnable(this.task.getPriority(), new Runnable(){

            @Override
            public void run() {
                try {
                    if (TaskProxy.this.callOnCanceled || TaskProxy.this.isCancelled()) {
                        throw new Callback.CancelledException("");
                    }
                    TaskProxy.this.onStarted();
                    if (TaskProxy.this.isCancelled()) {
                        throw new Callback.CancelledException("");
                    }
                    TaskProxy.this.task.setResult(TaskProxy.this.task.doBackground());
                    TaskProxy.this.setResult(TaskProxy.this.task.getResult());
                    if (TaskProxy.this.isCancelled()) {
                        throw new Callback.CancelledException("");
                    }
                    TaskProxy.this.onSuccess(TaskProxy.this.task.getResult());
                }
                catch (Callback.CancelledException cex) {
                    TaskProxy.this.onCancelled(cex);
                }
                catch (Throwable ex) {
                    TaskProxy.this.onError(ex, false);
                }
                finally {
                    TaskProxy.this.onFinished();
                }
            }
        });
        this.executor.execute(runnable);
        return null;
    }

    @Override
    protected void onWaiting() {
        this.setState(AbsTask.State.WAITING);
        sHandler.obtainMessage(1000000001, this).sendToTarget();
    }

    @Override
    protected void onStarted() {
        this.setState(AbsTask.State.STARTED);
        sHandler.obtainMessage(1000000002, this).sendToTarget();
    }

    @Override
    protected void onSuccess(ResultType result) {
        this.setState(AbsTask.State.SUCCESS);
        sHandler.obtainMessage(1000000003, this).sendToTarget();
    }

    @Override
    protected void onError(Throwable ex, boolean isCallbackError) {
        this.setState(AbsTask.State.ERROR);
        sHandler.obtainMessage(1000000004, new ArgsObj(this, ex)).sendToTarget();
    }

    @Override
    protected void onUpdate(int flag, Object ... args) {
        sHandler.obtainMessage(1000000005, flag, flag, new ArgsObj(this, args)).sendToTarget();
    }

    @Override
    protected void onCancelled(Callback.CancelledException cex) {
        this.setState(AbsTask.State.CANCELLED);
        sHandler.obtainMessage(1000000006, new ArgsObj(this, cex)).sendToTarget();
    }

    @Override
    protected void onFinished() {
        sHandler.obtainMessage(1000000007, this).sendToTarget();
    }

    @Override
    final void setState(AbsTask.State state) {
        super.setState(state);
        this.task.setState(state);
    }

    @Override
    public final Priority getPriority() {
        return this.task.getPriority();
    }

    @Override
    public final Executor getExecutor() {
        return this.executor;
    }

    static final class InternalHandler
    extends Handler {
        private InternalHandler() {
            super(Looper.getMainLooper());
        }

        public void handleMessage(Message msg) {
            block21: {
                if (msg.obj == null) {
                    throw new IllegalArgumentException("msg must not be null");
                }
                TaskProxy taskProxy = null;
                Object[] args = null;
                if (msg.obj instanceof TaskProxy) {
                    taskProxy = (TaskProxy)msg.obj;
                } else if (msg.obj instanceof ArgsObj) {
                    ArgsObj argsObj = (ArgsObj)msg.obj;
                    taskProxy = argsObj.taskProxy;
                    args = argsObj.args;
                }
                if (taskProxy == null) {
                    throw new RuntimeException("msg.obj not instanceof TaskProxy");
                }
                try {
                    switch (msg.what) {
                        case 1000000001: {
                            taskProxy.task.onWaiting();
                            break;
                        }
                        case 1000000002: {
                            taskProxy.task.onStarted();
                            break;
                        }
                        case 1000000003: {
                            taskProxy.task.onSuccess(taskProxy.getResult());
                            break;
                        }
                        case 1000000004: {
                            assert (args != null);
                            Throwable throwable = (Throwable)args[0];
                            LogUtil.d(throwable.getMessage(), throwable);
                            taskProxy.task.onError(throwable, false);
                            break;
                        }
                        case 1000000005: {
                            taskProxy.task.onUpdate(msg.arg1, args);
                            break;
                        }
                        case 1000000006: {
                            if (taskProxy.callOnCanceled) {
                                return;
                            }
                            taskProxy.callOnCanceled = true;
                            assert (args != null);
                            taskProxy.task.onCancelled((Callback.CancelledException)args[0]);
                            break;
                        }
                        case 1000000007: {
                            if (taskProxy.callOnFinished) {
                                return;
                            }
                            taskProxy.callOnFinished = true;
                            taskProxy.task.onFinished();
                            break;
                        }
                    }
                }
                catch (Throwable ex) {
                    taskProxy.setState(AbsTask.State.ERROR);
                    if (msg.what != 1000000004) {
                        taskProxy.task.onError(ex, true);
                    }
                    if (!x.isDebug()) break block21;
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private static class ArgsObj {
        final TaskProxy taskProxy;
        final Object[] args;

        public ArgsObj(TaskProxy taskProxy, Object ... args) {
            this.taskProxy = taskProxy;
            this.args = args;
        }
    }
}

