/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.widget;

import android.app.Dialog;
import android.content.Context;
import android.text.format.DateUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.szboanda.android.platform.R;
import com.szboanda.android.platform.widget.DateTimePicker;
import java.util.Calendar;

public class DateTimePickerDialog
extends Dialog
implements View.OnClickListener {
    private OnDateTimeSetListener mOnDateTimeSetListener;
    private Calendar mDate = Calendar.getInstance();

    public DateTimePickerDialog(Context context) {
        this(context, null);
    }

    public DateTimePickerDialog(Context context, DateTimePicker.PickerOptions opts) {
        super(context, R.style.WidgetDialog);
        this.setContentView(this.buildContentView(context, opts));
        WindowManager.LayoutParams params = this.getWindow().getAttributes();
        params.gravity = 80;
        params.width = -1;
    }

    private View buildContentView(Context context, DateTimePicker.PickerOptions opts) {
        int px = this.dip2Px(context, 10);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        RelativeLayout root = new RelativeLayout(context);
        root.setBackgroundColor(-1);
        root.setLayoutParams((ViewGroup.LayoutParams)params);
        root.setPadding(px, px, px, px);
        TextView cancel = new TextView(context);
        cancel.setId(16908313);
        cancel.setPadding(px, px, px, px);
        cancel.setClickable(true);
        cancel.setTextSize(16.0f);
        cancel.setTextColor(context.getResources().getColor(R.color.cancel_text_color));
        cancel.setText((CharSequence)context.getResources().getString(R.string.cancel));
        RelativeLayout.LayoutParams paramsc = new RelativeLayout.LayoutParams(-2, -2);
        paramsc.addRule(9);
        paramsc.addRule(10);
        root.addView((View)cancel, (ViewGroup.LayoutParams)paramsc);
        TextView ok = new TextView(context);
        ok.setId(16908314);
        ok.setPadding(px, px, px, px);
        ok.setClickable(true);
        ok.setTextSize(16.0f);
        ok.setTextColor(context.getResources().getColor(R.color.ok_text_color));
        ok.setText((CharSequence)context.getResources().getString(R.string.ok));
        RelativeLayout.LayoutParams paramso = new RelativeLayout.LayoutParams(-2, -2);
        paramso.addRule(11);
        paramso.addRule(10);
        root.addView((View)ok, (ViewGroup.LayoutParams)paramso);
        DateTimePicker picker = new DateTimePicker(context, opts);
        RelativeLayout.LayoutParams paramsp = new RelativeLayout.LayoutParams(-1, -2);
        paramsp.addRule(13);
        paramsp.addRule(3, 16908313);
        root.addView((View)picker, (ViewGroup.LayoutParams)paramsp);
        cancel.setOnClickListener((View.OnClickListener)this);
        ok.setOnClickListener((View.OnClickListener)this);
        picker.setOnDateTimeChangedListener(new DateTimePicker.OnDateTimeChangedListener(){

            @Override
            public void onDateTimeChanged(DateTimePicker view, int year, int month, int day, int hour, int minute) {
                DateTimePickerDialog.this.mDate.set(1, year);
                DateTimePickerDialog.this.mDate.set(2, month);
                DateTimePickerDialog.this.mDate.set(5, day);
                DateTimePickerDialog.this.mDate.set(11, hour);
                DateTimePickerDialog.this.mDate.set(12, minute);
                DateTimePickerDialog.this.mDate.set(13, 0);
            }
        });
        return root;
    }

    private int dip2Px(Context context, int dip) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)((float)dip * scale + 0.5f * (float)(dip >= 0 ? 1 : -1));
    }

    public void onClick(View v) {
        if (v.getId() == 16908313) {
            this.dismiss();
        } else if (v.getId() == 16908314) {
            this.dismiss();
            if (this.mOnDateTimeSetListener != null) {
                this.mOnDateTimeSetListener.OnDateTimeSet(this, this.mDate.getTimeInMillis());
            }
        }
    }

    public String getDateDescription() {
        int flag = 23;
        return DateUtils.formatDateTime((Context)this.getContext(), (long)this.mDate.getTimeInMillis(), (int)flag);
    }

    public void setOnDateTimeSetListener(OnDateTimeSetListener callBack) {
        this.mOnDateTimeSetListener = callBack;
    }

    public static interface OnDateTimeSetListener {
        public void OnDateTimeSet(Dialog var1, long var2);
    }
}

