/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view.wheel;

import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import com.szboanda.android.platform.util.ViewUtils;
import com.szboanda.android.platform.view.wheel.AbstractWheelTextAdapter;
import com.szboanda.android.platform.view.wheel.ItemsRange;
import com.szboanda.android.platform.view.wheel.OnWheelChangedListener;
import com.szboanda.android.platform.view.wheel.OnWheelClickedListener;
import com.szboanda.android.platform.view.wheel.OnWheelScrollListener;
import com.szboanda.android.platform.view.wheel.WheelRecycle;
import com.szboanda.android.platform.view.wheel.WheelScroller;
import com.szboanda.android.platform.view.wheel.WheelViewAdapter;
import java.util.LinkedList;
import java.util.List;

public class WheelView
extends View {
    private static final int ITEM_OFFSET_PERCENT = 0;
    private static final int PADDING = 5;
    private static final int DEF_VISIBLE_ITEMS = 5;
    private int currentItemIndex = 0;
    private int visibleItemsCount = 5;
    private int itemHeight = 0;
    private Drawable centerDrawable;
    private GradientDrawable topShadow;
    private WheelScroller scroller;
    private boolean isScrollingPerformed;
    private int scrollingOffset;
    boolean isCyclic = false;
    private LinearLayout itemsLayout;
    private int firstItemIndex;
    private WheelViewAdapter viewAdapter;
    private WheelRecycle recycle = new WheelRecycle(this);
    private List<OnWheelChangedListener> changingListeners = new LinkedList<OnWheelChangedListener>();
    private List<OnWheelScrollListener> scrollingListeners = new LinkedList<OnWheelScrollListener>();
    private List<OnWheelClickedListener> clickingListeners = new LinkedList<OnWheelClickedListener>();
    WheelScroller.ScrollingListener scrollingListener = new WheelScroller.ScrollingListener(){

        @Override
        public void onStarted() {
            WheelView.this.isScrollingPerformed = true;
            WheelView.this.notifyScrollingListenersAboutStart();
        }

        @Override
        public void onScroll(int distance) {
            WheelView.this.doScroll(distance);
            int height = (int)Math.round((double)WheelView.this.getHeight() / 2.56);
            if (WheelView.this.scrollingOffset > height) {
                WheelView.this.scrollingOffset = height;
                WheelView.this.scroller.stopScrolling();
            } else if (WheelView.this.scrollingOffset < -height) {
                WheelView.this.scrollingOffset = -height;
                WheelView.this.scroller.stopScrolling();
            }
        }

        @Override
        public void onFinished() {
            if (WheelView.this.isScrollingPerformed) {
                WheelView.this.notifyScrollingListenersAboutEnd();
                WheelView.this.isScrollingPerformed = false;
            }
            WheelView.this.scrollingOffset = 0;
            WheelView.this.invalidate();
        }

        @Override
        public void onJustify() {
            if (Math.abs(WheelView.this.scrollingOffset) > 1) {
                WheelView.this.scroller.scroll(WheelView.this.scrollingOffset, 0);
            }
        }
    };
    private DataSetObserver dataObserver = new DataSetObserver(){

        public void onChanged() {
            WheelView.this.invalidateWheel(false);
        }

        public void onInvalidated() {
            WheelView.this.invalidateWheel(true);
        }
    };

    public WheelView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initData(context);
    }

    public WheelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initData(context);
    }

    public WheelView(Context context) {
        super(context);
        this.initData(context);
    }

    private void initData(Context context) {
        this.scroller = new WheelScroller(this.getContext(), this.scrollingListener);
    }

    public void setInterpolator(Interpolator interpolator) {
        this.scroller.setInterpolator(interpolator);
    }

    public int getVisibleItems() {
        return this.visibleItemsCount;
    }

    public void setVisibleItems(int count) {
        this.visibleItemsCount = count;
    }

    public WheelViewAdapter getViewAdapter() {
        return this.viewAdapter;
    }

    public void setViewAdapter(WheelViewAdapter viewAdapter) {
        if (this.viewAdapter != null) {
            this.viewAdapter.unregisterDataSetObserver(this.dataObserver);
        }
        this.viewAdapter = viewAdapter;
        if (this.viewAdapter != null) {
            this.viewAdapter.registerDataSetObserver(this.dataObserver);
        }
        this.invalidateWheel(true);
    }

    public void addChangingListener(OnWheelChangedListener listener) {
        this.changingListeners.add(listener);
    }

    public void removeChangingListener(OnWheelChangedListener listener) {
        this.changingListeners.remove(listener);
    }

    protected void notifyChangingListeners(int oldValue, int newValue) {
        for (OnWheelChangedListener listener : this.changingListeners) {
            listener.onChanged(this, oldValue, newValue);
        }
    }

    public void addScrollingListener(OnWheelScrollListener listener) {
        this.scrollingListeners.add(listener);
    }

    public void removeScrollingListener(OnWheelScrollListener listener) {
        this.scrollingListeners.remove(listener);
    }

    protected void notifyScrollingListenersAboutStart() {
        for (OnWheelScrollListener listener : this.scrollingListeners) {
            listener.onScrollingStarted(this);
        }
    }

    protected void notifyScrollingListenersAboutEnd() {
        for (OnWheelScrollListener listener : this.scrollingListeners) {
            listener.onScrollingFinished(this);
        }
    }

    public void addClickingListener(OnWheelClickedListener listener) {
        this.clickingListeners.add(listener);
    }

    public void removeClickingListener(OnWheelClickedListener listener) {
        this.clickingListeners.remove(listener);
    }

    protected void notifyClickListenersAboutClick(int item) {
        for (OnWheelClickedListener listener : this.clickingListeners) {
            listener.onItemClicked(this, item);
        }
    }

    public int getCurrentItem() {
        return this.currentItemIndex;
    }

    public void setCurrentItem(int index, boolean animated) {
        if (this.viewAdapter == null || this.viewAdapter.getItemsCount() == 0) {
            return;
        }
        int itemCount = this.viewAdapter.getItemsCount();
        if (index < 0 || index >= itemCount) {
            if (this.isCyclic) {
                while (index < 0) {
                    index += itemCount;
                }
                index %= itemCount;
            } else {
                return;
            }
        }
        if (index != this.currentItemIndex) {
            if (animated) {
                int scroll;
                int itemsToScroll = index - this.currentItemIndex;
                if (this.isCyclic && (scroll = itemCount + Math.min(index, this.currentItemIndex) - Math.max(index, this.currentItemIndex)) < Math.abs(itemsToScroll)) {
                    itemsToScroll = itemsToScroll < 0 ? scroll : -scroll;
                }
                this.scroll(itemsToScroll, 0);
            } else {
                this.scrollingOffset = 0;
                int old = this.currentItemIndex;
                this.currentItemIndex = index;
                this.notifyChangingListeners(old, this.currentItemIndex);
                if (this.viewAdapter instanceof AbstractWheelTextAdapter && index >= this.viewAdapter.getScopeFloorIndex() && index <= this.viewAdapter.getScopeUpperIndex()) {
                    AbstractWheelTextAdapter absAdapter = (AbstractWheelTextAdapter)this.viewAdapter;
                    absAdapter.configureTextView(old, false);
                    absAdapter.configureTextView(this.currentItemIndex, true);
                }
                this.invalidate();
            }
        }
    }

    public void setCurrentItem(int index) {
        this.setCurrentItem(index, false);
    }

    public boolean isCyclic() {
        return this.isCyclic;
    }

    public void setCyclic(boolean isCyclic) {
        this.isCyclic = isCyclic;
        this.invalidateWheel(false);
    }

    public void invalidateWheel(boolean clearCaches) {
        if (clearCaches) {
            this.recycle.clearAll();
            if (this.itemsLayout != null) {
                this.itemsLayout.removeAllViews();
            }
            this.scrollingOffset = 0;
        } else if (this.itemsLayout != null) {
            this.recycle.recycleItems(this.itemsLayout, this.firstItemIndex, new ItemsRange());
        }
        this.invalidate();
    }

    private void initResourcesIfNecessary() {
        if (this.centerDrawable == null) {
            // empty if block
        }
    }

    private int getDesiredHeight(LinearLayout layout2) {
        if (layout2 != null && layout2.getChildAt(0) != null) {
            this.itemHeight = layout2.getChildAt(0).getMeasuredHeight();
        }
        int desired = this.itemHeight * this.visibleItemsCount - this.itemHeight * 0 / 50;
        return Math.max(desired, this.getSuggestedMinimumHeight());
    }

    private int getItemHeight() {
        if (this.itemHeight != 0) {
            return this.itemHeight;
        }
        if (this.itemsLayout != null && this.itemsLayout.getChildAt(0) != null) {
            this.itemHeight = this.itemsLayout.getChildAt(0).getHeight();
            return this.itemHeight;
        }
        return this.getHeight() / this.visibleItemsCount;
    }

    private int calculateLayoutWidth(int widthSize, int mode) {
        this.initResourcesIfNecessary();
        this.itemsLayout.setLayoutParams(new ViewGroup.LayoutParams(-2, 50));
        this.itemsLayout.measure(View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        int width = this.itemsLayout.getMeasuredWidth();
        if (mode == 0x40000000) {
            width = widthSize;
        } else {
            width += 10;
            width = Math.max(width, this.getSuggestedMinimumWidth());
            if (mode == Integer.MIN_VALUE && widthSize < width) {
                width = widthSize;
            }
        }
        this.itemsLayout.measure(View.MeasureSpec.makeMeasureSpec((int)(width - 10), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        return width;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.buildViewForMeasuring();
        int width = this.calculateLayoutWidth(widthSize, widthMode);
        View viewItem = this.itemsLayout.getChildAt(0);
        int itemHeight = ViewUtils.measureView(viewItem)[1];
        this.setMeasuredDimension(width, this.visibleItemsCount * itemHeight);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.layout(r - l, b - t);
    }

    private void layout(int width, int height) {
        int itemsWidth = width - 10;
        this.itemsLayout.layout(0, 0, itemsWidth, height);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.viewAdapter != null && this.viewAdapter.getItemsCount() > 0) {
            this.updateView();
            this.drawItems(canvas);
            this.drawCenterRect(canvas);
        }
    }

    private void drawItems(Canvas canvas) {
        canvas.save();
        int top = (this.currentItemIndex - this.firstItemIndex) * this.getItemHeight() + (this.getItemHeight() - this.getHeight()) / 2;
        canvas.translate(5.0f, (float)(-top + this.scrollingOffset));
        this.itemsLayout.draw(canvas);
        canvas.restore();
    }

    private void drawCenterRect(Canvas canvas) {
        if (this.centerDrawable == null) {
            return;
        }
        int center = this.getHeight() / 2;
        int offset = (int)((double)(this.getItemHeight() / 2) * 1.2);
        this.centerDrawable.setBounds(0, center - offset, this.getWidth(), center + offset);
        this.centerDrawable.draw(canvas);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled() || this.getViewAdapter() == null) {
            return true;
        }
        switch (event.getAction()) {
            case 2: {
                if (this.getParent() == null) break;
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 1: {
                if (this.isScrollingPerformed) break;
                int distance = (int)event.getY() - this.getHeight() / 2;
                distance = distance > 0 ? (distance += this.getItemHeight() / 2) : (distance -= this.getItemHeight() / 2);
                int items = distance / this.getItemHeight();
                if (items == 0) {
                    this.notifyClickListenersAboutClick(this.currentItemIndex);
                }
                if (items == 0 || !this.isValidItemIndex(this.currentItemIndex + items)) break;
                this.setCurrentItem(this.currentItemIndex + items);
            }
        }
        return this.scroller.onTouchEvent(event);
    }

    private void doScroll(int delta) {
        this.scrollingOffset += delta;
        int itemHeight = this.getItemHeight();
        int count = this.scrollingOffset / itemHeight;
        int pos = this.currentItemIndex - count;
        int itemCount = this.viewAdapter.getItemsCount();
        int fixPos = this.scrollingOffset % itemHeight;
        if (Math.abs(fixPos) <= itemHeight / 2) {
            fixPos = 0;
        }
        if (this.isCyclic && itemCount > 0) {
            if (fixPos > 0) {
                --pos;
                ++count;
            } else if (fixPos < 0) {
                ++pos;
                --count;
            }
            while (pos < 0) {
                pos += itemCount;
            }
            pos %= itemCount;
        } else if (pos < 0) {
            count = this.currentItemIndex;
            pos = 0;
        } else if (pos >= itemCount) {
            count = this.currentItemIndex - itemCount + 1;
            pos = itemCount - 1;
        } else if (pos > 0 && fixPos > 0) {
            --pos;
            ++count;
        } else if (pos < itemCount - 1 && fixPos < 0) {
            ++pos;
            --count;
        }
        int offset = this.scrollingOffset;
        if (this.viewAdapter != null && (pos < this.viewAdapter.getScopeFloorIndex() || pos > this.viewAdapter.getScopeUpperIndex())) {
            this.stopScrolling();
            return;
        }
        if (pos != this.currentItemIndex) {
            this.setCurrentItem(pos, false);
        } else {
            this.invalidate();
        }
        this.scrollingOffset = offset - count * itemHeight;
        if (this.scrollingOffset > this.getHeight()) {
            this.scrollingOffset = this.scrollingOffset % this.getHeight() + this.getHeight();
        }
    }

    public void scroll(int itemsToScroll, int time) {
        int distance = itemsToScroll * this.getItemHeight() - this.scrollingOffset;
        this.scroller.scroll(distance, time);
    }

    private ItemsRange getItemsRange() {
        if (this.getItemHeight() == 0) {
            return null;
        }
        int first = this.currentItemIndex;
        int count = 1;
        while (count * this.getItemHeight() < this.getHeight()) {
            --first;
            count += 2;
        }
        if (this.scrollingOffset != 0) {
            if (this.scrollingOffset > 0) {
                --first;
            }
            ++count;
            int emptyItems = this.scrollingOffset / this.getItemHeight();
            first -= emptyItems;
            count = (int)((double)count + Math.asin(emptyItems));
        }
        return new ItemsRange(first, count);
    }

    private boolean rebuildItems() {
        int first;
        boolean updated = false;
        ItemsRange range = this.getItemsRange();
        if (this.itemsLayout != null) {
            first = this.recycle.recycleItems(this.itemsLayout, this.firstItemIndex, range);
            updated = this.firstItemIndex != first;
            this.firstItemIndex = first;
        } else {
            this.createItemsLayout();
            updated = true;
        }
        if (!updated) {
            boolean bl = updated = this.firstItemIndex != range.getFirst() || this.itemsLayout.getChildCount() != range.getCount();
        }
        if (this.firstItemIndex > range.getFirst() && this.firstItemIndex <= range.getLast()) {
            int i = this.firstItemIndex - 1;
            while (i >= range.getFirst() && this.addViewItem(i, true)) {
                this.firstItemIndex = i--;
            }
        } else {
            this.firstItemIndex = range.getFirst();
        }
        first = this.firstItemIndex;
        for (int i = this.itemsLayout.getChildCount(); i < range.getCount(); ++i) {
            if (this.addViewItem(this.firstItemIndex + i, false) || this.itemsLayout.getChildCount() != 0) continue;
            ++first;
        }
        this.firstItemIndex = first;
        return updated;
    }

    private void updateView() {
        if (this.rebuildItems()) {
            this.calculateLayoutWidth(this.getWidth(), 0x40000000);
            this.layout(this.getWidth(), this.getHeight());
        }
    }

    private void createItemsLayout() {
        if (this.itemsLayout == null) {
            this.itemsLayout = new LinearLayout(this.getContext());
            this.itemsLayout.setOrientation(1);
            this.itemsLayout.setGravity(1);
        }
    }

    private void buildViewForMeasuring() {
        if (this.itemsLayout != null) {
            this.recycle.recycleItems(this.itemsLayout, this.firstItemIndex, new ItemsRange());
        } else {
            this.createItemsLayout();
        }
        int addItems = this.visibleItemsCount / 2;
        for (int i = this.currentItemIndex + addItems; i >= this.currentItemIndex - addItems; --i) {
            if (!this.addViewItem(i, true)) continue;
            this.firstItemIndex = i;
        }
    }

    private boolean addViewItem(int index, boolean first) {
        View view = this.getItemView(index);
        if (view != null) {
            if (first) {
                this.itemsLayout.addView(view, 0);
            } else {
                this.itemsLayout.addView(view);
            }
            return true;
        }
        return false;
    }

    private boolean isValidItemIndex(int index) {
        return this.viewAdapter != null && this.viewAdapter.getItemsCount() > 0 && (this.isCyclic || index >= 0 && index < this.viewAdapter.getItemsCount());
    }

    private View getItemView(int index) {
        if (this.viewAdapter == null || this.viewAdapter.getItemsCount() == 0) {
            return null;
        }
        int count = this.viewAdapter.getItemsCount();
        if (!this.isValidItemIndex(index)) {
            return this.viewAdapter.getEmptyItem(this.recycle.getEmptyItem(), (ViewGroup)this.itemsLayout);
        }
        while (index < 0) {
            index = count + index;
        }
        return this.viewAdapter.getItem(index, this.recycle.getItem(), (ViewGroup)this.itemsLayout, (index %= count) == this.currentItemIndex);
    }

    public void stopScrolling() {
        this.scroller.stopScrolling();
    }
}

