/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view.wheel;

import android.content.Context;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.szboanda.android.platform.view.wheel.AbstractWheelAdapter;

public abstract class AbstractWheelTextAdapter
extends AbstractWheelAdapter {
    public static final int TEXT_VIEW_ITEM_RESOURCE = -1;
    protected static final int NO_RESOURCE = 0;
    public static final int DEFAULT_TEXT_COLOR = -3026479;
    public static final int CURRENT_DEFAULT_TEXT_COLOR = -10053121;
    public static final int LABEL_COLOR = -9437072;
    public static final int CONFIG_TEXT_COLOR = -10053121;
    public static final int DEFAULT_TEXT_SIZE = 20;
    public static final int CURRENT_DEFAULT_TEXT_SIZE = 20;
    private int textColor = -3026479;
    private int textSize = 20;
    private int curTextColor = -10053121;
    private int curTextSize = 20;
    private String textType = "";
    private SparseArray<TextView> textViewSparseArray = new SparseArray();
    protected Context context;
    protected LayoutInflater inflater;
    protected int itemResourceId;
    protected int itemTextResourceId;
    protected int emptyItemResourceId;

    public String getTextType() {
        return this.textType;
    }

    public void setTextType(String textType) {
        this.textType = textType;
    }

    protected AbstractWheelTextAdapter(Context context) {
        this(context, -1);
    }

    protected AbstractWheelTextAdapter(Context context, int itemResource) {
        this(context, itemResource, 0);
    }

    protected AbstractWheelTextAdapter(Context context, int itemResource, int itemTextResource) {
        this.context = context;
        this.itemResourceId = itemResource;
        this.itemTextResourceId = itemTextResource;
        this.inflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public void setCurTextColor(int textColor) {
        this.curTextColor = textColor;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    public void setCurTextSize(int textSize) {
        this.curTextSize = textSize;
    }

    public int getItemResource() {
        return this.itemResourceId;
    }

    public void setItemResource(int itemResourceId) {
        this.itemResourceId = itemResourceId;
    }

    public int getItemTextResource() {
        return this.itemTextResourceId;
    }

    public void setItemTextResource(int itemTextResourceId) {
        this.itemTextResourceId = itemTextResourceId;
    }

    public int getEmptyItemResource() {
        return this.emptyItemResourceId;
    }

    public void setEmptyItemResource(int emptyItemResourceId) {
        this.emptyItemResourceId = emptyItemResourceId;
    }

    protected abstract CharSequence getItemText(int var1);

    @Override
    public View getItem(int index, View convertView, ViewGroup parent) {
        return this.getItem(index, convertView, parent, false);
    }

    @Override
    public View getItem(int index, View convertView, ViewGroup parent, boolean isCurrentItem) {
        if (index >= 0 && index < this.getItemsCount()) {
            if (convertView == null) {
                convertView = this.getView(this.itemResourceId, parent);
            }
            TextView textView = this.getTextView(convertView, this.itemTextResourceId);
            textView.setPadding(0, 6, 0, 6);
            if (textView != null) {
                CharSequence text = this.getItemText(index);
                if (text == null) {
                    text = "";
                }
                textView.setText(text);
                if (this.itemResourceId == -1) {
                    this.configureTextView(textView, isCurrentItem);
                }
                this.textViewSparseArray.put(index, (Object)textView);
            }
            return convertView;
        }
        return null;
    }

    @Override
    public View getEmptyItem(View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = this.getView(this.emptyItemResourceId, parent);
        }
        if (this.emptyItemResourceId == -1 && convertView instanceof TextView) {
            this.configureTextView((TextView)convertView, false);
        }
        return convertView;
    }

    protected void configureTextView(TextView view, boolean isCurrentItem) {
        view.setTextColor(isCurrentItem ? this.curTextColor : this.textColor);
        view.setTextSize(isCurrentItem ? (float)this.curTextSize : (float)this.textSize);
        view.setGravity(17);
        view.setLines(1);
        view.setText((CharSequence)(view.getText() + this.textType));
    }

    protected void configureTextView(int index, boolean isCurrentItem) {
        TextView tv = (TextView)this.textViewSparseArray.get(index);
        if (tv == null) {
            return;
        }
        tv.setTextColor(isCurrentItem ? this.curTextColor : this.textColor);
        tv.setTextSize(isCurrentItem ? (float)this.curTextSize : (float)this.textSize);
    }

    private TextView getTextView(View view, int textResource) {
        TextView text = null;
        try {
            if (textResource == 0 && view instanceof TextView) {
                text = (TextView)view;
            } else if (textResource != 0) {
                text = (TextView)view.findViewById(textResource);
            }
        }
        catch (ClassCastException e) {
            Log.e((String)"AbstractWheelAdapter", (String)"You must supply a resource ID for a TextView");
            throw new IllegalStateException("AbstractWheelAdapter requires the resource ID to be a TextView", e);
        }
        return text;
    }

    private View getView(int resource, ViewGroup parent) {
        switch (resource) {
            case 0: {
                return null;
            }
            case -1: {
                return new TextView(this.context);
            }
        }
        return this.inflater.inflate(resource, parent, false);
    }
}

