/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.szboanda.android.platform.R;
import com.szboanda.android.platform.util.DateUtils;
import com.szboanda.android.platform.util.DimensionUtils;
import com.szboanda.android.platform.view.wheel.OnWheelChangedListener;
import com.szboanda.android.platform.view.wheel.StringWheelAdapter;
import com.szboanda.android.platform.view.wheel.WheelView;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class DateTimePicker
extends LinearLayout {
    public static final String UNIT_YEAR = "\u5e74";
    public static final String UNIT_MONTH = "\u6708";
    public static final String UNIT_DAY = "\u65e5";
    public static final String UNIT_HOUR = "\u65f6";
    public static final String UNIT_MIN = "\u5206";
    Calendar mCalendar;
    PickType mPickType;
    int yearViewIndex;
    int monthViewIndex;
    int dayViewIndex;
    int hourViewIndex;
    int minViewIndex;
    StringWheelAdapter yearAdapter;
    StringWheelAdapter monthAdapter;
    StringWheelAdapter dayAdapter;
    StringWheelAdapter hourAdapter;
    StringWheelAdapter minAdapter;
    private OnCalenderChangeListener mChangeListener;
    OnWheelChangedListener yearChangeListener = new OnWheelChangedListener(){

        @Override
        public void onChanged(WheelView wheel, int oldIndex, int newIndex) {
            String value = DateTimePicker.this.yearAdapter.getItemText(newIndex).toString();
            int year = DateTimePicker.this.getValue(value, DateTimePicker.UNIT_YEAR);
            int preMaxDay = DateTimePicker.this.mCalendar.getActualMaximum(5);
            int month = DateTimePicker.this.mCalendar.get(2);
            DateTimePicker.this.mCalendar.set(1, year);
            if (month == 1) {
                DateTimePicker.this.mCalendar.set(5, 1);
                DateTimePicker.this.onMouthMaxDaysChange(preMaxDay);
            }
            if (DateTimePicker.this.mChangeListener != null) {
                DateTimePicker.this.mChangeListener.onCalenderChange(DateTimePicker.this.getFormatValue());
            }
        }
    };
    OnWheelChangedListener monthChangeListener = new OnWheelChangedListener(){

        @Override
        public void onChanged(WheelView wheel, int oldIndex, int newIndex) {
            String value = DateTimePicker.this.monthAdapter.getItemText(newIndex).toString();
            int month = DateTimePicker.this.getValue(value, DateTimePicker.UNIT_MONTH);
            int preMaxDay = DateTimePicker.this.mCalendar.getActualMaximum(5);
            int preYear = DateTimePicker.this.mCalendar.get(1);
            DateTimePicker.this.mCalendar.set(preYear, month - 1, 1);
            DateTimePicker.this.onMouthMaxDaysChange(preMaxDay);
            if (DateTimePicker.this.mChangeListener != null) {
                DateTimePicker.this.mChangeListener.onCalenderChange(DateTimePicker.this.getFormatValue());
            }
        }
    };
    OnWheelChangedListener dayChangeListener = new OnWheelChangedListener(){

        @Override
        public void onChanged(WheelView wheel, int oldIndex, int newIndex) {
            String value = DateTimePicker.this.dayAdapter.getItemText(newIndex).toString();
            int day = DateTimePicker.this.getValue(value, DateTimePicker.UNIT_DAY);
            DateTimePicker.this.mCalendar.set(5, day);
            if (DateTimePicker.this.mChangeListener != null) {
                DateTimePicker.this.mChangeListener.onCalenderChange(DateTimePicker.this.getFormatValue());
            }
        }
    };
    OnWheelChangedListener hourChangeListener = new OnWheelChangedListener(){

        @Override
        public void onChanged(WheelView wheel, int oldIndex, int newIndex) {
            String value = DateTimePicker.this.hourAdapter.getItemText(newIndex).toString();
            int hour = DateTimePicker.this.getValue(value, DateTimePicker.UNIT_HOUR);
            DateTimePicker.this.mCalendar.set(11, hour);
            if (DateTimePicker.this.mChangeListener != null) {
                DateTimePicker.this.mChangeListener.onCalenderChange(DateTimePicker.this.getFormatValue());
            }
        }
    };
    OnWheelChangedListener minChangeListener = new OnWheelChangedListener(){

        @Override
        public void onChanged(WheelView wheel, int oldIndex, int newIndex) {
            String value = DateTimePicker.this.minAdapter.getItemText(newIndex).toString();
            int min = DateTimePicker.this.getValue(value, DateTimePicker.UNIT_MIN);
            DateTimePicker.this.mCalendar.set(12, min);
            if (DateTimePicker.this.mChangeListener != null) {
                DateTimePicker.this.mChangeListener.onCalenderChange(DateTimePicker.this.getFormatValue());
            }
        }
    };

    public DateTimePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.DateTimePicker);
        int pickTypeIndex = ta.getInt(R.styleable.DateTimePicker_select_type, 0);
        this.mPickType = PickType.values()[pickTypeIndex];
        ta.recycle();
        this.init();
    }

    public DateTimePicker(Context context, PickType pickType) {
        super(context);
        this.mPickType = pickType;
        this.init();
    }

    private void init() {
        this.setOrientation(0);
        this.mCalendar = Calendar.getInstance(Locale.getDefault());
        this.createView();
        this.initData();
        this.initListener();
    }

    private void createView() {
        int colCount = 0;
        switch (this.mPickType) {
            case TIME: {
                colCount = 2;
                this.hourViewIndex = 0;
                this.minViewIndex = 1;
                break;
            }
            case DATE: {
                colCount = 3;
                this.yearViewIndex = 0;
                this.monthViewIndex = 1;
                this.dayViewIndex = 2;
                break;
            }
            case DATE_TIME: {
                colCount = 5;
                this.yearViewIndex = 0;
                this.monthViewIndex = 1;
                this.dayViewIndex = 2;
                this.hourViewIndex = 3;
                this.minViewIndex = 4;
                break;
            }
        }
        for (int i = 1; i <= colCount; ++i) {
            View colView = this.createSingleColumn(i);
            this.addView(colView);
        }
    }

    private View createSingleColumn(int colIndex) {
        int h = DimensionUtils.getScreenHeight(this.getContext(), 30);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(0, h);
        lp.weight = 1.0f;
        WheelView wv = new WheelView(this.getContext());
        wv.setId(colIndex);
        wv.setLayoutParams((ViewGroup.LayoutParams)lp);
        return wv;
    }

    public void setDate(Date date) {
        this.mCalendar.setTime(date);
        this.initData();
    }

    public void initData() {
        switch (this.mPickType) {
            case TIME: {
                this.setHourColumnData();
                this.setMinColumnData();
                break;
            }
            case DATE: {
                this.setYearColumnData();
                this.setMonthColumnData();
                this.setDayColumnData();
                break;
            }
            case DATE_TIME: {
                this.setYearColumnData();
                this.setMonthColumnData();
                this.setDayColumnData();
                this.setHourColumnData();
                this.setMinColumnData();
                break;
            }
        }
    }

    public Calendar getDate() {
        return this.mCalendar;
    }

    public String getFormatValue() {
        String result = "";
        switch (this.mPickType) {
            case TIME: {
                result = DateUtils.formatDate(this.mCalendar.getTime(), "HH:mm");
                break;
            }
            case DATE: {
                result = DateUtils.formatDate(this.mCalendar.getTime(), "yyyy-MM-dd");
                break;
            }
            case DATE_TIME: {
                result = DateUtils.formatDate(this.mCalendar.getTime(), "yyyy-MM-dd HH:mm");
                break;
            }
        }
        return result;
    }

    private void setYearColumnData() {
        int curYear = this.mCalendar.get(1);
        int startY = curYear - 100;
        int endY = curYear + 100;
        WheelView viewYear = (WheelView)this.getChildAt(this.yearViewIndex);
        this.yearAdapter = new StringWheelAdapter(this.getContext(), this.getFieldRange(startY, endY, ""));
        viewYear.setViewAdapter(this.yearAdapter);
        viewYear.setCurrentItem(curYear - startY);
    }

    private void setMonthColumnData() {
        int curMonth = this.mCalendar.get(2) + 1;
        WheelView viewMonth = (WheelView)this.getChildAt(this.monthViewIndex);
        this.monthAdapter = new StringWheelAdapter(this.getContext(), this.getFieldRange(1, 12, ""));
        viewMonth.setViewAdapter(this.monthAdapter);
        viewMonth.setCurrentItem(curMonth - 1);
    }

    private void setDayColumnData() {
        int curDay = this.mCalendar.get(5);
        int maxDay = this.mCalendar.getActualMaximum(5);
        WheelView viewDay = (WheelView)this.getChildAt(this.dayViewIndex);
        this.dayAdapter = new StringWheelAdapter(this.getContext(), this.getFieldRange(1, maxDay, ""));
        viewDay.setViewAdapter(this.dayAdapter);
        viewDay.setCurrentItem(curDay - 1);
    }

    private void setHourColumnData() {
        int curHour = this.mCalendar.get(11);
        WheelView viewHour = (WheelView)this.getChildAt(this.hourViewIndex);
        this.hourAdapter = new StringWheelAdapter(this.getContext(), this.getFieldRange(0, 23, ""));
        viewHour.setViewAdapter(this.hourAdapter);
        viewHour.setCurrentItem(curHour);
    }

    private void setMinColumnData() {
        int curMin = this.mCalendar.get(12);
        WheelView viewMin = (WheelView)this.getChildAt(this.minViewIndex);
        this.minAdapter = new StringWheelAdapter(this.getContext(), this.getFieldRange(0, 59, ""));
        viewMin.setViewAdapter(this.minAdapter);
        viewMin.setCurrentItem(curMin);
    }

    private String prefixNum(int num) {
        return num < 10 ? "0" + num : "" + num;
    }

    public List<String> getFieldRange(int start, int end, String unit) {
        ArrayList<String> ranges = new ArrayList<String>();
        for (int i = start; i <= end; ++i) {
            ranges.add(this.prefixNum(i) + unit);
        }
        return ranges;
    }

    private void initListener() {
        switch (this.mPickType) {
            case TIME: {
                WheelView hourView = (WheelView)this.getChildAt(this.hourViewIndex);
                WheelView minView = (WheelView)this.getChildAt(this.minViewIndex);
                hourView.addChangingListener(this.hourChangeListener);
                minView.addChangingListener(this.minChangeListener);
                break;
            }
            case DATE: {
                WheelView yearView = (WheelView)this.getChildAt(this.yearViewIndex);
                WheelView monthView = (WheelView)this.getChildAt(this.monthViewIndex);
                WheelView dayView = (WheelView)this.getChildAt(this.dayViewIndex);
                yearView.addChangingListener(this.yearChangeListener);
                monthView.addChangingListener(this.monthChangeListener);
                dayView.addChangingListener(this.dayChangeListener);
                break;
            }
            case DATE_TIME: {
                WheelView yearView = (WheelView)this.getChildAt(this.yearViewIndex);
                WheelView monthView = (WheelView)this.getChildAt(this.monthViewIndex);
                WheelView dayView = (WheelView)this.getChildAt(this.dayViewIndex);
                WheelView hourView = (WheelView)this.getChildAt(this.hourViewIndex);
                WheelView minView = (WheelView)this.getChildAt(this.minViewIndex);
                yearView.addChangingListener(this.yearChangeListener);
                monthView.addChangingListener(this.monthChangeListener);
                dayView.addChangingListener(this.dayChangeListener);
                hourView.addChangingListener(this.hourChangeListener);
                minView.addChangingListener(this.minChangeListener);
                break;
            }
        }
    }

    public int getValue(String valueStr, String unit) {
        return TextUtils.isEmpty((CharSequence)valueStr) ? -1 : Integer.valueOf(valueStr.replace(unit, ""));
    }

    private void onMouthMaxDaysChange(int preMaxDay) {
        int curMaxDay = this.mCalendar.getActualMaximum(5);
        WheelView dayView = (WheelView)this.getChildAt(this.dayViewIndex);
        int curDayIndex = dayView.getCurrentItem();
        if (preMaxDay != curMaxDay) {
            List<String> days = this.getFieldRange(1, curMaxDay, "");
            this.dayAdapter.setItemsData(days);
            dayView.invalidateWheel(true);
            int curDay = Math.min(curMaxDay, curDayIndex + 1);
            curDayIndex = curDay - 1;
            dayView.setCurrentItem(curDayIndex);
        }
        this.mCalendar.set(5, curDayIndex + 1);
    }

    public void setOnCalenderChangeListener(OnCalenderChangeListener listener) {
        this.mChangeListener = listener;
    }

    public static enum PickType {
        DATE,
        TIME,
        DATE_TIME;

    }

    public static interface OnCalenderChangeListener {
        public void onCalenderChange(String var1);
    }
}

