/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.szboanda.android.platform.R;
import com.szboanda.android.platform.util.JsonUtils;
import com.szboanda.android.platform.util.ResourceUtils;
import com.szboanda.android.platform.view.CustomViewBinder;
import com.szboanda.android.platform.view.IBindableView;
import org.json.JSONObject;

public class BindableViewHandler
implements CustomViewBinder.IKeyConvertable {
    private String field;
    private String notEmptyMsg;
    private String multiValueSeparator;
    private IBindableView mHostView;
    private JSONObject mData;
    private CustomViewBinder.IKeyConvertor mKeyConvertor;

    public BindableViewHandler(IBindableView hostView) {
        this.mHostView = hostView;
    }

    public void initWithTypedArray(TypedArray ta) {
        int splitIndex;
        String viewName = this.mHostView.getClass().getName();
        int index = viewName.lastIndexOf(".");
        viewName = viewName.substring(index + 1);
        String fieldDefineName = viewName + "_dbField";
        String msgDefineName = viewName + "_notEmptyMsg";
        String splitDefineName = viewName + "_multiValueSeparator";
        Context context = ((View)this.mHostView).getContext();
        this.field = ta.getString(ResourceUtils.getStyleableInt(context, fieldDefineName));
        int msgIndex = ResourceUtils.getStyleableInt(context, msgDefineName);
        if (msgIndex != -1) {
            this.notEmptyMsg = ta.getString(msgIndex);
        }
        if ((splitIndex = ResourceUtils.getStyleableInt(context, splitDefineName)) != -1) {
            this.multiValueSeparator = ta.getString(splitIndex);
        }
        this.field = this.initDefaultString(this.field);
        this.notEmptyMsg = this.initDefaultString(this.notEmptyMsg);
    }

    public void initWithTypedArray(Resources res, AttributeSet attrs) {
        TypedArray ta = res.obtainAttributes(attrs, R.styleable.boanda);
        this.field = ta.getString(R.styleable.boanda_dbField);
        this.notEmptyMsg = ta.getString(R.styleable.boanda_notEmptyMsg);
        this.multiValueSeparator = ta.getString(R.styleable.boanda_multiValueSeparator);
        ta.recycle();
        this.field = this.initDefaultString(this.field);
        this.notEmptyMsg = this.initDefaultString(this.notEmptyMsg);
    }

    public String initDefaultString(String value) {
        return this.initDefaultString(value, "");
    }

    public String initDefaultString(String value, String emptyValue) {
        String result = TextUtils.isEmpty((CharSequence)value) ? emptyValue : value;
        return result;
    }

    public String getField() {
        return this.mKeyConvertor == null ? this.field : this.acceptConvert(this.mKeyConvertor);
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setKeyConvert(CustomViewBinder.IKeyConvertor convertor) {
        this.mKeyConvertor = convertor;
    }

    public void setNotEmptyMsg(String notEmptyMsg) {
        this.notEmptyMsg = notEmptyMsg;
    }

    public String getEmptyMsg() {
        return this.notEmptyMsg;
    }

    public String getMultiValueSeparator() {
        return this.multiValueSeparator;
    }

    public void setMultiValueSeparator(String multiValueSeparator) {
        this.multiValueSeparator = multiValueSeparator;
    }

    public CustomViewBinder.IKeyConvertor getKeyConvertor() {
        return this.mKeyConvertor;
    }

    public void bindValue(JSONObject data, boolean enable) {
        this.mData = data;
        if (data.has(this.getField())) {
            String value = data.optString(this.getField());
            this.mHostView.setBindValue(value);
        }
        ((View)this.mHostView).setEnabled(enable);
    }

    public String appendValue(JSONObject data) {
        String value = this.mHostView.getBindValue().trim();
        if (!TextUtils.isEmpty((CharSequence)value)) {
            if (this.isMultiValue()) {
                if (this.isComplexField()) {
                    String[] fields = this.getField().split(this.multiValueSeparator);
                    String[] values = value.split(this.multiValueSeparator);
                    int index = 0;
                    for (String f : fields) {
                        String v = index < values.length ? values[index] : "";
                        JsonUtils.put(data, f, v);
                        ++index;
                    }
                } else {
                    String existValue = data.optString(this.getField(), "");
                    if ((existValue = existValue + this.multiValueSeparator + value).startsWith(this.multiValueSeparator)) {
                        existValue = existValue.substring(1);
                    }
                    JsonUtils.put(data, this.getField(), existValue);
                }
            } else {
                JsonUtils.put(data, this.getField(), value);
            }
        }
        return !TextUtils.isEmpty((CharSequence)this.notEmptyMsg) && TextUtils.isEmpty((CharSequence)value) ? this.notEmptyMsg : "";
    }

    public String optFieldValue(String field) {
        if (this.mData == null) {
            return "";
        }
        return this.mData.optString(field);
    }

    public boolean isMultiValue() {
        return !TextUtils.isEmpty((CharSequence)this.multiValueSeparator);
    }

    public boolean isComplexField() {
        return !TextUtils.isEmpty((CharSequence)this.multiValueSeparator) && this.getField().contains(this.multiValueSeparator);
    }

    @Override
    public String acceptConvert(CustomViewBinder.IKeyConvertor convertor) {
        return convertor.convertKey(this);
    }
}

