/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.RadioButton;
import com.szboanda.android.platform.R;
import com.szboanda.android.platform.view.BindableViewHandler;
import com.szboanda.android.platform.view.IBindableView;

public class BindableRadioButton
extends RadioButton
implements IBindableView {
    private BindableViewHandler mBindHandler;
    private String checkedValue;
    private int radioViewId;

    public BindableRadioButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public BindableRadioButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mBindHandler = new BindableViewHandler(this);
        this.mBindHandler.initWithTypedArray(this.getResources(), attrs);
        TypedArray ta = this.getResources().obtainAttributes(attrs, R.styleable.BindableRadioButton);
        this.checkedValue = ta.getString(R.styleable.BindableRadioButton_checkedValue);
        if (TextUtils.isEmpty((CharSequence)this.checkedValue)) {
            this.checkedValue = this.getText().toString();
        }
        ta.recycle();
        this.bindViewListener();
    }

    public BindableRadioButton(Context context) {
        super(context);
        this.mBindHandler = new BindableViewHandler(this);
        this.setGravity(16);
    }

    @Override
    public void setField(String dbField) {
        this.mBindHandler.setField(dbField);
    }

    public int getRadioViewId() {
        return this.radioViewId;
    }

    public void setFieldValue(String fieldValue) {
        this.checkedValue = fieldValue;
    }

    public String getFieldValue() {
        String value = "";
        if (this.isChecked()) {
            value = this.checkedValue;
        }
        return value;
    }

    private void bindViewListener() {
        if (this.radioViewId != -1) {
            this.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    View view = ((Activity)BindableRadioButton.this.getContext()).findViewById(BindableRadioButton.this.radioViewId);
                    if (view != null) {
                        view.setVisibility(isChecked ? 0 : 8);
                    }
                }
            });
        }
    }

    @Override
    public void setEmptyMsg(String notEmptyTipMsg) {
        this.mBindHandler.setNotEmptyMsg(notEmptyTipMsg);
    }

    @Override
    public void setBindValue(String value) {
        this.setChecked(this.checkedValue.equals(value));
    }

    @Override
    public String getBindValue() {
        return this.isChecked() ? this.checkedValue : "";
    }

    @Override
    public BindableViewHandler getBindHandler() {
        return this.mBindHandler;
    }
}

